/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery.utils;

import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorProcessEntryPoint {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorProcessEntryPoint.class);

    public static void main(String[] args) {
        try {
            ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
            Configuration cfg = parameterTool.getConfiguration();
            PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder((Configuration)cfg);
            TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)cfg);
            TaskManagerRunner.runTaskManager((Configuration)cfg, (PluginManager)pluginManager);
        }
        catch (Throwable t) {
            LOG.error("Failed to run the TaskManager process", t);
            System.exit(1);
        }
    }
}

