/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;

abstract class PluginTestBase
extends TestLogger {
    private static final String OPT_PREFIX = "target/";
    static final String PLUGIN_A = "plugin-a-test-jar.jar";
    static final String PLUGIN_B = "plugin-b-test-jar.jar";
    static final ClassLoader PARENT_CLASS_LOADER = PluginTestBase.class.getClassLoader();

    PluginTestBase() {
    }

    URL createPluginJarURLFromString(String fileString) throws MalformedURLException {
        File file = PluginTestBase.locateJarFile(fileString);
        return file.toURI().toURL();
    }

    static File locateJarFile(String fileString) {
        File file = new File(fileString);
        if (!file.exists()) {
            file = new File(OPT_PREFIX + fileString);
        }
        Preconditions.checkState((boolean)file.exists(), (Object)("Unable to locate jar file for test: " + fileString));
        return file;
    }
}

