/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.optimizer.jsonplan;

import java.util.List;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.examples.java.clustering.KMeans;
import org.apache.flink.examples.java.graph.ConnectedComponents;
import org.apache.flink.examples.java.graph.PageRank;
import org.apache.flink.examples.java.relational.TPCHQuery3;
import org.apache.flink.examples.java.relational.WebLogAnalysis;
import org.apache.flink.examples.java.wordcount.WordCount;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.junit.Assert;
import org.junit.Test;

public class PreviewPlanDumpTest
extends CompilerTestBase {
    @Test
    public void dumpWordCount() throws Exception {
        PreviewPlanDumpTest.verifyPlanDump(WordCount.class, "--input", IN_FILE, "--output", OUT_FILE);
    }

    @Test
    public void dumpTPCH3() throws Exception {
        PreviewPlanDumpTest.verifyPlanDump(TPCHQuery3.class, "--lineitem", IN_FILE, "--customer", IN_FILE, "--orders", OUT_FILE, "--output", "123");
    }

    @Test
    public void dumpIterativeKMeans() throws Exception {
        PreviewPlanDumpTest.verifyPlanDump(KMeans.class, "--points ", IN_FILE, "--centroids ", IN_FILE, "--output ", OUT_FILE, "--iterations", "123");
    }

    @Test
    public void dumpWebLogAnalysis() throws Exception {
        PreviewPlanDumpTest.verifyPlanDump(WebLogAnalysis.class, "--documents", IN_FILE, "--ranks", IN_FILE, "--visits", OUT_FILE, "--output", "123");
    }

    @Test
    public void dumpBulkIterationKMeans() throws Exception {
        PreviewPlanDumpTest.verifyPlanDump(ConnectedComponents.class, "--vertices", IN_FILE, "--edges", IN_FILE, "--output", OUT_FILE, "--iterations", "123");
    }

    @Test
    public void dumpPageRank() throws Exception {
        PreviewPlanDumpTest.verifyPlanDump(PageRank.class, "--pages", IN_FILE, "--links", IN_FILE, "--output", OUT_FILE, "--numPages", "10", "--iterations", "123");
    }

    private static void verifyPlanDump(Class<?> entrypoint, String ... args) throws Exception {
        PackagedProgram program = PackagedProgram.newBuilder().setEntryPointClassName(entrypoint.getName()).setArguments(args).build();
        Pipeline pipeline = PackagedProgramUtils.getPipelineFromProgram((PackagedProgram)program, (Configuration)new Configuration(), (int)1, (boolean)true);
        Assert.assertTrue((boolean)(pipeline instanceof Plan));
        Plan plan = (Plan)pipeline;
        List sinks = Optimizer.createPreOptimizedPlan((Plan)plan);
        PlanJSONDumpGenerator dumper = new PlanJSONDumpGenerator();
        String json = dumper.getPactPlanAsJSON(sinks);
        try (JsonParser parser = new JsonFactory().createParser(json);){
            while (parser.nextToken() != null) {
            }
        }
    }
}

