/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.misc;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.Collector;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class MiscellaneousIssuesITCase
extends TestLogger {
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(2).setNumberSlotsPerTaskManager(3).build());

    @Test
    public void testNullValues() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(1);
            MapOperator data = env.fromElements((Object[])new String[]{"hallo"}).map((MapFunction)new MapFunction<String, String>(){

                public String map(String value) throws Exception {
                    return null;
                }
            });
            data.writeAsText("/tmp/myTest", FileSystem.WriteMode.OVERWRITE);
            try {
                env.execute();
                Assert.fail((String)"this should fail due to null values.");
            }
            catch (JobExecutionException e) {
                Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)e, NullPointerException.class).isPresent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDisjointDataflows() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(5);
            env.generateSequence(1L, 10L).output((OutputFormat)new DiscardingOutputFormat());
            env.generateSequence(1L, 10L).output((OutputFormat)new DiscardingOutputFormat());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAccumulatorsAfterNoOp() {
        String accName = "test_accumulator";
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(6);
            env.generateSequence(1L, 1000000L).rebalance().flatMap((FlatMapFunction)new RichFlatMapFunction<Long, Long>(){
                private LongCounter counter;

                public void open(Configuration parameters) {
                    this.counter = this.getRuntimeContext().getLongCounter("test_accumulator");
                }

                public void flatMap(Long value, Collector<Long> out) {
                    this.counter.add(1L);
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            JobExecutionResult result = env.execute();
            Assert.assertEquals((Object)1000000L, result.getAllAccumulatorResults().get("test_accumulator"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

