/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.misc;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.junit.Assert;

public class CustomPartitioningITCase
extends JavaProgramTestBase {
    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (!this.isCollectionExecution()) {
            Assert.assertTrue((env.getParallelism() > 1 ? 1 : 0) != 0);
        }
        env.generateSequence(1L, 1000L).partitionCustom((Partitioner)new AllZeroPartitioner(), new IdKeySelector()).map((MapFunction)new FailExceptInPartitionZeroMapper()).output((OutputFormat)new DiscardingOutputFormat());
        env.execute();
    }

    private static class IdKeySelector<T>
    implements KeySelector<T, T> {
        private IdKeySelector() {
        }

        public T getKey(T value) {
            return value;
        }
    }

    private static class AllZeroPartitioner
    implements Partitioner<Long> {
        private AllZeroPartitioner() {
        }

        public int partition(Long key, int numPartitions) {
            return 0;
        }
    }

    private static class FailExceptInPartitionZeroMapper
    extends RichMapFunction<Long, Long> {
        private FailExceptInPartitionZeroMapper() {
        }

        public Long map(Long value) throws Exception {
            if (this.getRuntimeContext().getIndexOfThisSubtask() == 0) {
                return value;
            }
            throw new Exception("Received data in a partition other than partition 0");
        }
    }
}

