/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.io.Serializable;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.test.util.CoordVector;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.test.util.PointFormatter;
import org.apache.flink.test.util.PointInFormat;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;

public class IterationWithUnionITCase
extends JavaProgramTestBase {
    private static final String DATAPOINTS = "0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n";
    protected String dataPath;
    protected String resultPath;

    protected void preSubmit() throws Exception {
        this.dataPath = this.createTempFile("datapoints.txt", DATAPOINTS);
        this.resultPath = this.getTempDirPath("union_iter_result");
    }

    protected void postSubmit() throws Exception {
        TestBaseUtils.compareResultsByLinesInMemory((String)"0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n", (String)this.resultPath);
    }

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        Operator initialInput = env.readFile((FileInputFormat)new PointInFormat(), this.dataPath).setParallelism(1);
        IterativeDataSet iteration = initialInput.iterate(2);
        MapOperator result = iteration.union((DataSet)iteration).map((MapFunction)new IdentityMapper());
        iteration.closeWith((DataSet)result).writeAsFormattedText(this.resultPath, (TextOutputFormat.TextFormatter)new PointFormatter());
        env.execute();
    }

    static class DummyReducer
    implements GroupReduceFunction<Tuple2<Integer, CoordVector>, Tuple2<Integer, CoordVector>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        DummyReducer() {
        }

        public void reduce(Iterable<Tuple2<Integer, CoordVector>> it, Collector<Tuple2<Integer, CoordVector>> out) {
            for (Tuple2<Integer, CoordVector> r : it) {
                out.collect(r);
            }
        }
    }

    static final class IdentityMapper
    implements MapFunction<Tuple2<Integer, CoordVector>, Tuple2<Integer, CoordVector>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        IdentityMapper() {
        }

        public Tuple2<Integer, CoordVector> map(Tuple2<Integer, CoordVector> rec) {
            return rec;
        }
    }
}

