/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.example.java;

import java.io.BufferedReader;
import org.apache.flink.examples.java.graph.TransitiveClosureNaive;
import org.apache.flink.test.testdata.ConnectedComponentsData;
import org.apache.flink.test.testdata.TransitiveClosureData;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.test.util.TestBaseUtils;

public class TransitiveClosureITCase
extends JavaProgramTestBase {
    private static final long SEED = 3287269182979823L;
    private static final int NUM_VERTICES = 100;
    private static final int NUM_EDGES = 500;
    private String edgesPath;
    private String resultPath;

    protected void preSubmit() throws Exception {
        this.edgesPath = this.createTempFile("edges.txt", ConnectedComponentsData.getRandomOddEvenEdges((int)500, (int)100, (long)3287269182979823L));
        this.resultPath = this.getTempFilePath("results");
    }

    protected void testProgram() throws Exception {
        TransitiveClosureNaive.main((String[])new String[]{"--edges", this.edgesPath, "--output", this.resultPath, "--iterations", "5"});
    }

    protected void postSubmit() throws Exception {
        for (BufferedReader reader : TestBaseUtils.getResultReader((String)this.resultPath)) {
            TransitiveClosureData.checkOddEvenResult((BufferedReader)reader);
        }
    }
}

