/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.example.failing;

import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;

public class TaskFailureITCase
extends JavaProgramTestBase {
    private static final String EXCEPTION_STRING = "This is an expected Test Exception";

    protected void testProgram() throws Exception {
        try {
            this.executeTask((MapFunction<Long, Long>)new FailingTestMapper(), 1);
        }
        catch (RuntimeException e) {
            if (!this.isCollectionExecution()) {
                Assert.fail();
            }
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)"This is an expected Test Exception:0").isPresent());
        }
        catch (JobExecutionException e) {
            if (this.isCollectionExecution()) {
                Assert.fail();
            }
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)"This is an expected Test Exception:1").isPresent());
        }
        this.executeTask(new TestMapper(), 0);
    }

    private void executeTask(MapFunction<Long, Long> mapper, int retries) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        env.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)retries, (long)0L));
        List result = env.generateSequence(1L, 9L).map(mapper).collect();
        TestBaseUtils.compareResultAsText((List)result, (String)"1\n2\n3\n4\n5\n6\n7\n8\n9");
    }

    public static class FailingTestMapper
    extends RichMapFunction<Long, Long> {
        private static final long serialVersionUID = 1L;

        public Long map(Long value) throws Exception {
            throw new RuntimeException("This is an expected Test Exception:" + this.getRuntimeContext().getAttemptNumber());
        }
    }

    public static class TestMapper
    implements MapFunction<Long, Long> {
        private static final long serialVersionUID = 1L;

        public Long map(Long value) throws Exception {
            return value;
        }
    }
}

