/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.validation;

import java.util.List;
import org.apache.flink.runtime.operators.lifecycle.TestJobWithDescription;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointCompletedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.TestEvent;
import org.apache.flink.runtime.operators.lifecycle.validation.TestOperatorLifecycleValidator;
import org.junit.Assert;

public class SameCheckpointValidator
implements TestOperatorLifecycleValidator {
    private final long lastCheckpointID;

    public SameCheckpointValidator(long lastCheckpointID) {
        this.lastCheckpointID = lastCheckpointID;
    }

    @Override
    public void validateOperatorLifecycle(TestJobWithDescription job, String operatorId, int subtaskIndex, List<TestEvent> operatorEvents) {
        boolean started = false;
        boolean finished = false;
        for (TestEvent ev : operatorEvents) {
            if (ev instanceof CheckpointStartedEvent) {
                if (this.lastCheckpointID != ((CheckpointStartedEvent)ev).checkpointID) continue;
                Assert.assertFalse((String)String.format("Operator %s[%d] started checkpoint %d twice", operatorId, subtaskIndex, this.lastCheckpointID), (boolean)started);
                started = true;
                continue;
            }
            if (!(ev instanceof CheckpointCompletedEvent) || this.lastCheckpointID != ((CheckpointCompletedEvent)ev).checkpointID) continue;
            Assert.assertTrue((String)String.format("Operator %s[%d] finished checkpoint %d before starting", operatorId, subtaskIndex, this.lastCheckpointID), (boolean)started);
            Assert.assertFalse((String)String.format("Operator %s[%d] finished checkpoint %d twice", operatorId, subtaskIndex, this.lastCheckpointID), (boolean)finished);
            finished = true;
        }
        Assert.assertTrue((String)String.format("Operator %s[%d] didn't finish checkpoint %d (events: %s)", operatorId, subtaskIndex, this.lastCheckpointID, operatorEvents), (boolean)finished);
    }
}

