/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class SystemResourcesMetricsITCase
extends TestLogger {
    @ClassRule
    public static final MiniClusterResource MINI_CLUSTER_RESOURCE = new MiniClusterResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(SystemResourcesMetricsITCase.getConfiguration()).setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    private static Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setBoolean(MetricOptions.SYSTEM_RESOURCE_METRICS, true);
        configuration.setString(MetricOptions.REPORTERS_LIST, "test_reporter");
        configuration.setString(MetricOptions.SCOPE_NAMING_JM, "jobmanager");
        configuration.setString(MetricOptions.SCOPE_NAMING_TM, "taskmanager");
        configuration.setString("metrics.reporter.test_reporter.class", TestReporter.class.getName());
        return configuration;
    }

    @Test
    public void startTaskManagerAndCheckForRegisteredSystemMetrics() throws Exception {
        Assert.assertEquals((long)1L, (long)TestReporter.OPENED_REPORTERS.size());
        TestReporter reporter = TestReporter.OPENED_REPORTERS.iterator().next();
        reporter.patternsExhaustedFuture.get(10L, TimeUnit.SECONDS);
    }

    private static List<String> getExpectedPatterns() {
        String[] expectedGauges = new String[]{"System.CPU.Idle", "System.CPU.Sys", "System.CPU.User", "System.CPU.IOWait", "System.CPU.Irq", "System.CPU.SoftIrq", "System.CPU.Steal", "System.CPU.Nice", "System.Memory.Available", "System.Memory.Total", "System.Swap.Used", "System.Swap.Total", "System.Network.*ReceiveRate", "System.Network.*SendRate"};
        String[] expectedHosts = new String[]{"taskmanager.", "jobmanager."};
        ArrayList<String> patterns = new ArrayList<String>();
        for (String expectedHost : expectedHosts) {
            for (String expectedGauge : expectedGauges) {
                patterns.add(expectedHost + expectedGauge);
            }
        }
        return patterns;
    }

    static /* synthetic */ List access$100() {
        return SystemResourcesMetricsITCase.getExpectedPatterns();
    }

    public static final class TestReporter
    implements MetricReporter {
        public static final Set<TestReporter> OPENED_REPORTERS = ConcurrentHashMap.newKeySet();
        private final Map<String, CompletableFuture<Void>> patternFutures = SystemResourcesMetricsITCase.access$100().stream().collect(Collectors.toMap(pattern -> pattern, pattern -> new CompletableFuture()));
        private final CompletableFuture<Void> patternsExhaustedFuture = FutureUtils.waitForAll(this.patternFutures.values());

        public void open(MetricConfig config) {
            OPENED_REPORTERS.add(this);
        }

        public void close() {
            OPENED_REPORTERS.remove(this);
        }

        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            String metricIdentifier = group.getMetricIdentifier(metricName, CharacterFilter.NO_OP_FILTER);
            for (String expectedPattern : this.patternFutures.keySet()) {
                if (!metricIdentifier.matches(expectedPattern)) continue;
                this.patternFutures.get(expectedPattern).complete(null);
            }
        }

        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        }
    }
}

