/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.JobExecutor;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;

public class TestStreamEnvironment
extends StreamExecutionEnvironment {
    private final JobExecutor jobExecutor;
    private final Collection<Path> jarFiles;
    private final Collection<URL> classPaths;

    public TestStreamEnvironment(JobExecutor jobExecutor, int parallelism, Collection<Path> jarFiles, Collection<URL> classPaths) {
        this.jobExecutor = (JobExecutor)Preconditions.checkNotNull((Object)jobExecutor);
        this.jarFiles = (Collection)Preconditions.checkNotNull(jarFiles);
        this.classPaths = (Collection)Preconditions.checkNotNull(classPaths);
        this.setParallelism(parallelism);
    }

    public TestStreamEnvironment(JobExecutor jobExecutor, int parallelism) {
        this(jobExecutor, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        JobGraph jobGraph = streamGraph.getJobGraph();
        for (Path jarFile : this.jarFiles) {
            jobGraph.addJar(jarFile);
        }
        jobGraph.setClasspaths(new ArrayList<URL>(this.classPaths));
        return this.jobExecutor.executeJobBlocking(jobGraph);
    }

    public static void setAsContext(final JobExecutor jobExecutor, final int parallelism, final Collection<Path> jarFiles, final Collection<URL> classpaths) {
        StreamExecutionEnvironmentFactory factory = new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment() {
                return new TestStreamEnvironment(jobExecutor, parallelism, jarFiles, classpaths);
            }
        };
        TestStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(JobExecutor jobExecutor, int parallelism) {
        TestStreamEnvironment.setAsContext(jobExecutor, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestStreamEnvironment.resetContextEnvironment();
    }
}

