/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.CollectionTestEnvironment;
import org.apache.flink.test.util.TestEnvironment;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class MultipleProgramsTestBase
extends AbstractTestBase {
    @Parameter
    protected TestExecutionMode mode;

    @BeforeEach
    public void setupEnvironment() {
        switch (this.mode) {
            case CLUSTER: {
                TestEnvironment testEnvironment = MINI_CLUSTER_EXTENSION.getTestEnvironment();
                testEnvironment.getConfig().disableObjectReuse();
                testEnvironment.setAsContext();
                break;
            }
            case CLUSTER_OBJECT_REUSE: {
                TestEnvironment testEnvironment = MINI_CLUSTER_EXTENSION.getTestEnvironment();
                testEnvironment.getConfig().enableObjectReuse();
                testEnvironment.setAsContext();
                break;
            }
            case COLLECTION: {
                new CollectionTestEnvironment().setAsContext();
            }
        }
    }

    @AfterEach
    public void teardownEnvironment() {
        switch (this.mode) {
            case CLUSTER: 
            case CLUSTER_OBJECT_REUSE: {
                TestEnvironment.unsetAsContext();
                break;
            }
            case COLLECTION: {
                CollectionTestEnvironment.unsetAsContext();
            }
        }
    }

    @Parameters(name="Execution mode = {0}")
    public static Collection<TestExecutionMode> executionModes() {
        return Arrays.asList(TestExecutionMode.CLUSTER, TestExecutionMode.COLLECTION);
    }

    public static enum TestExecutionMode {
        CLUSTER,
        CLUSTER_OBJECT_REUSE,
        COLLECTION;

    }
}

