/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.sink;

import java.io.File;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.upserttest.sink.UpsertTestSink;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class UpsertTestSinkBuilder<IN> {
    private File outputFile;
    private SerializationSchema<IN> keySerializationSchema;
    private SerializationSchema<IN> valueSerializationSchema;

    public UpsertTestSinkBuilder<IN> setOutputFile(File outputFile) {
        this.outputFile = (File)Preconditions.checkNotNull((Object)outputFile);
        return this;
    }

    public UpsertTestSinkBuilder<IN> setKeySerializationSchema(SerializationSchema<IN> keySerializationSchema) {
        this.keySerializationSchema = (SerializationSchema)Preconditions.checkNotNull(keySerializationSchema);
        return this;
    }

    public UpsertTestSinkBuilder<IN> setValueSerializationSchema(SerializationSchema<IN> valueSerializationSchema) {
        this.valueSerializationSchema = (SerializationSchema)Preconditions.checkNotNull(valueSerializationSchema);
        return this;
    }

    public UpsertTestSink<IN> build() {
        Preconditions.checkNotNull((Object)this.outputFile);
        Preconditions.checkNotNull(this.keySerializationSchema);
        Preconditions.checkNotNull(this.valueSerializationSchema);
        return new UpsertTestSink<IN>(this.outputFile, this.keySerializationSchema, this.valueSerializationSchema);
    }
}

