/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class OneShotLatch {
    private final Object lock = new Object();
    private volatile boolean triggered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        Object object = this.lock;
        synchronized (object) {
            this.triggered = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.triggered) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("time may not be negative");
        }
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit");
        }
        if (timeout == 0L) {
            this.await();
        } else {
            long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
            Object object = this.lock;
            synchronized (object) {
                long millisToWait;
                while (!this.triggered && (millisToWait = (deadline - System.nanoTime()) / 1000000L) > 0L) {
                    this.lock.wait(millisToWait);
                }
                if (!this.triggered) {
                    throw new TimeoutException();
                }
            }
        }
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.triggered = false;
        }
    }

    public String toString() {
        return "Latch " + (this.triggered ? "TRIGGERED" : "PENDING");
    }
}

