/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayJoinFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;

    public ArrayJoinFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_JOIN, context);
        DataType elementDataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)elementDataType.getLogicalType());
    }

    @Nullable
    public StringData eval(ArrayData array, StringData delimiter, StringData ... nullReplacement) {
        try {
            if (array == null || delimiter == null || nullReplacement.length != 0 && nullReplacement[0] == null) {
                return null;
            }
            StringData normalizedReplacement = nullReplacement.length != 0 && nullReplacement[0] != null ? nullReplacement[0] : null;
            return BinaryStringDataUtil.concatWs((BinaryStringData)delimiter, () -> new ArrayIterator(this.elementGetter, array, (BinaryStringData)normalizedReplacement));
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    static final class ArrayIterator
    implements Iterator<BinaryStringData> {
        private final int size;
        private final ArrayData.ElementGetter elementGetter;
        private final ArrayData arrayData;
        private final BinaryStringData nullReplacement;
        private int currentPos;

        public ArrayIterator(ArrayData.ElementGetter elementGetter, ArrayData arrayData, BinaryStringData nullReplacement) {
            this.size = arrayData.size();
            this.elementGetter = elementGetter;
            this.arrayData = arrayData;
            this.nullReplacement = nullReplacement;
        }

        @Override
        public boolean hasNext() {
            return this.currentPos < this.size;
        }

        @Override
        public BinaryStringData next() {
            if (!this.hasNext()) {
                return null;
            }
            Object str = this.elementGetter.getElementOrNull(this.arrayData, this.currentPos);
            ++this.currentPos;
            if (str == null && this.nullReplacement != null) {
                return this.nullReplacement;
            }
            return (BinaryStringData)str;
        }
    }
}

