/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

public final class DataTypePrecisionFixer
implements DataTypeVisitor<DataType> {
    private final LogicalType logicalType;

    public DataTypePrecisionFixer(LogicalType logicalType) {
        this.logicalType = logicalType;
    }

    public DataType visit(AtomicDataType dataType) {
        switch (this.logicalType.getTypeRoot()) {
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)this.logicalType;
                return (DataType)DataTypes.DECIMAL((int)decimalType.getPrecision(), (int)decimalType.getScale()).bridgedTo(dataType.getConversionClass());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)this.logicalType;
                if (timestampType.getKind() == TimestampKind.REGULAR) {
                    return (DataType)DataTypes.TIMESTAMP((int)timestampType.getPrecision()).bridgedTo(dataType.getConversionClass());
                }
                return dataType;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)this.logicalType;
                return (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)localZonedTimestampType.getPrecision()).bridgedTo(dataType.getConversionClass());
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                ZonedTimestampType zonedTimestampType = (ZonedTimestampType)this.logicalType;
                return (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)zonedTimestampType.getPrecision()).bridgedTo(dataType.getConversionClass());
            }
            case TIME_WITHOUT_TIME_ZONE: {
                TimeType timeType = (TimeType)this.logicalType;
                return (DataType)DataTypes.TIME((int)timeType.getPrecision()).bridgedTo(dataType.getConversionClass());
            }
        }
        return dataType;
    }

    public DataType visit(CollectionDataType collectionDataType) {
        DataType elementType = collectionDataType.getElementDataType();
        switch (this.logicalType.getTypeRoot()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)this.logicalType;
                DataType newArrayElementType = (DataType)elementType.accept((DataTypeVisitor)new DataTypePrecisionFixer(arrayType.getElementType()));
                return (DataType)DataTypes.ARRAY((DataType)newArrayElementType).bridgedTo(collectionDataType.getConversionClass());
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)this.logicalType;
                DataType newMultisetElementType = (DataType)elementType.accept((DataTypeVisitor)new DataTypePrecisionFixer(multisetType.getElementType()));
                return (DataType)DataTypes.MULTISET((DataType)newMultisetElementType).bridgedTo(collectionDataType.getConversionClass());
            }
        }
        throw new UnsupportedOperationException("Unsupported logical type : " + this.logicalType);
    }

    public DataType visit(FieldsDataType fieldsDataType) {
        List fieldDataTypes = fieldsDataType.getChildren();
        if (this.logicalType.getTypeRoot() == LogicalTypeRoot.ROW) {
            List fieldNames = LogicalTypeChecks.getFieldNames((LogicalType)this.logicalType);
            DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, fieldDataTypes.size()).mapToObj(i -> {
                DataType oldFieldType = (DataType)fieldDataTypes.get(i);
                DataType newFieldType = (DataType)oldFieldType.accept((DataTypeVisitor)new DataTypePrecisionFixer((LogicalType)this.logicalType.getChildren().get(i)));
                return DataTypes.FIELD((String)((String)fieldNames.get(i)), (DataType)newFieldType);
            }).toArray(DataTypes.Field[]::new);
            return (DataType)DataTypes.ROW((DataTypes.Field[])fields).bridgedTo(fieldsDataType.getConversionClass());
        }
        throw new UnsupportedOperationException("Unsupported logical type : " + this.logicalType);
    }

    public DataType visit(KeyValueDataType keyValueDataType) {
        DataType keyType = keyValueDataType.getKeyDataType();
        DataType valueType = keyValueDataType.getValueDataType();
        if (this.logicalType.getTypeRoot() == LogicalTypeRoot.MAP) {
            MapType mapType = (MapType)this.logicalType;
            DataType newKeyType = (DataType)keyType.accept((DataTypeVisitor)new DataTypePrecisionFixer(mapType.getKeyType()));
            DataType newValueType = (DataType)valueType.accept((DataTypeVisitor)new DataTypePrecisionFixer(mapType.getValueType()));
            return (DataType)DataTypes.MAP((DataType)newKeyType, (DataType)newValueType).bridgedTo(keyValueDataType.getConversionClass());
        }
        throw new UnsupportedOperationException("Unsupported logical type : " + this.logicalType);
    }
}

