/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

class DeduplicateFunctionHelper {
    static void processLastRowOnProcTime(RowData currentRow, boolean generateUpdateBefore, boolean generateInsert, ValueState<RowData> state, Collector<RowData> out, boolean isStateTtlEnabled, RecordEqualiser equaliser) throws Exception {
        DeduplicateFunctionHelper.checkInsertOnly(currentRow);
        if (generateUpdateBefore || generateInsert) {
            RowData preRow = (RowData)state.value();
            state.update((Object)currentRow);
            if (preRow == null) {
                currentRow.setRowKind(RowKind.INSERT);
                out.collect((Object)currentRow);
            } else {
                if (!isStateTtlEnabled && equaliser.equals(preRow, currentRow)) {
                    return;
                }
                if (generateUpdateBefore) {
                    preRow.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)preRow);
                }
                currentRow.setRowKind(RowKind.UPDATE_AFTER);
                out.collect((Object)currentRow);
            }
        } else {
            currentRow.setRowKind(RowKind.UPDATE_AFTER);
            out.collect((Object)currentRow);
        }
    }

    static void processLastRowOnChangelog(RowData currentRow, boolean generateUpdateBefore, ValueState<RowData> state, Collector<RowData> out, boolean isStateTtlEnabled, RecordEqualiser equaliser) throws Exception {
        RowData preRow = (RowData)state.value();
        RowKind currentKind = currentRow.getRowKind();
        if (currentKind == RowKind.INSERT || currentKind == RowKind.UPDATE_AFTER) {
            if (preRow == null) {
                currentRow.setRowKind(RowKind.INSERT);
                out.collect((Object)currentRow);
            } else {
                if (!isStateTtlEnabled && equaliser.equals(preRow, currentRow)) {
                    return;
                }
                if (generateUpdateBefore) {
                    preRow.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)preRow);
                }
                currentRow.setRowKind(RowKind.UPDATE_AFTER);
                out.collect((Object)currentRow);
            }
            currentRow.setRowKind(RowKind.INSERT);
            state.update((Object)currentRow);
        } else if (preRow != null) {
            preRow.setRowKind(RowKind.DELETE);
            out.collect((Object)preRow);
            state.clear();
        }
    }

    static void processFirstRowOnProcTime(RowData currentRow, ValueState<Boolean> state, Collector<RowData> out) throws Exception {
        DeduplicateFunctionHelper.checkInsertOnly(currentRow);
        if (state.value() != null) {
            return;
        }
        state.update((Object)true);
        out.collect((Object)currentRow);
    }

    static void updateDeduplicateResult(boolean generateUpdateBefore, boolean generateInsert, RowData preRow, RowData currentRow, Collector<RowData> out) {
        if (generateUpdateBefore || generateInsert) {
            if (preRow == null) {
                currentRow.setRowKind(RowKind.INSERT);
                out.collect((Object)currentRow);
            } else {
                if (generateUpdateBefore) {
                    RowKind preRowKind = preRow.getRowKind();
                    preRow.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)preRow);
                    preRow.setRowKind(preRowKind);
                }
                currentRow.setRowKind(RowKind.UPDATE_AFTER);
                out.collect((Object)currentRow);
            }
        } else {
            currentRow.setRowKind(RowKind.UPDATE_AFTER);
            out.collect((Object)currentRow);
        }
    }

    static boolean isDuplicate(RowData preRow, RowData currentRow, int rowtimeIndex, boolean keepLastRow) {
        if (keepLastRow) {
            return preRow == null || DeduplicateFunctionHelper.getRowtime(preRow, rowtimeIndex) <= DeduplicateFunctionHelper.getRowtime(currentRow, rowtimeIndex);
        }
        return preRow == null || DeduplicateFunctionHelper.getRowtime(currentRow, rowtimeIndex) < DeduplicateFunctionHelper.getRowtime(preRow, rowtimeIndex);
    }

    private static long getRowtime(RowData input, int rowtimeIndex) {
        return input.getLong(rowtimeIndex);
    }

    static void checkInsertOnly(RowData currentRow) {
        Preconditions.checkArgument((currentRow.getRowKind() == RowKind.INSERT ? 1 : 0) != 0);
    }

    private DeduplicateFunctionHelper() {
    }
}

