/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.combines;

import java.time.ZoneId;
import java.util.Iterator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.dataview.PerWindowStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.combines.RecordsCombiner;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.state.StateKeyContext;
import org.apache.flink.table.runtime.operators.window.state.WindowState;
import org.apache.flink.table.runtime.operators.window.state.WindowValueState;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.runtime.util.WindowKey;

public class GlobalAggCombiner
implements RecordsCombiner {
    private final WindowTimerService<Long> timerService;
    private final StateKeyContext keyContext;
    private final WindowValueState<Long> accState;
    private final NamespaceAggsHandleFunction<Long> localAggregator;
    private final NamespaceAggsHandleFunction<Long> globalAggregator;

    public GlobalAggCombiner(WindowTimerService<Long> timerService, StateKeyContext keyContext, WindowValueState<Long> accState, NamespaceAggsHandleFunction<Long> localAggregator, NamespaceAggsHandleFunction<Long> globalAggregator) {
        this.timerService = timerService;
        this.keyContext = keyContext;
        this.accState = accState;
        this.localAggregator = localAggregator;
        this.globalAggregator = globalAggregator;
    }

    @Override
    public void combine(WindowKey windowKey, Iterator<RowData> localAccs) throws Exception {
        Long window = windowKey.getWindow();
        RowData acc = this.localAggregator.createAccumulators();
        this.localAggregator.setAccumulators(window, acc);
        while (localAccs.hasNext()) {
            RowData localAcc = localAccs.next();
            this.localAggregator.merge(window, localAcc);
        }
        this.combineAccumulator(windowKey, this.localAggregator.getAccumulators());
    }

    private void combineAccumulator(WindowKey windowKey, RowData acc) throws Exception {
        this.keyContext.setCurrentKey(windowKey.getKey());
        Long window = windowKey.getWindow();
        RowData stateAcc = this.accState.value(window);
        if (stateAcc == null) {
            stateAcc = this.globalAggregator.createAccumulators();
        }
        this.globalAggregator.setAccumulators(window, stateAcc);
        this.globalAggregator.merge(window, acc);
        stateAcc = this.globalAggregator.getAccumulators();
        this.accState.update(window, stateAcc);
        long currentWatermark = this.timerService.currentWatermark();
        ZoneId shiftTimeZone = this.timerService.getShiftTimeZone();
        if (!TimeWindowUtil.isWindowFired(window, currentWatermark, shiftTimeZone)) {
            this.timerService.registerEventTimeWindowTimer(window);
        }
    }

    @Override
    public void close() throws Exception {
        this.localAggregator.close();
        this.globalAggregator.close();
    }

    public static final class Factory
    implements RecordsCombiner.Factory {
        private static final long serialVersionUID = 1L;
        private final GeneratedNamespaceAggsHandleFunction<Long> genLocalAggsHandler;
        private final GeneratedNamespaceAggsHandleFunction<Long> genGlobalAggsHandler;

        public Factory(GeneratedNamespaceAggsHandleFunction<Long> genLocalAggsHandler, GeneratedNamespaceAggsHandleFunction<Long> genGlobalAggsHandler) {
            this.genLocalAggsHandler = genLocalAggsHandler;
            this.genGlobalAggsHandler = genGlobalAggsHandler;
        }

        @Override
        public RecordsCombiner createRecordsCombiner(RuntimeContext runtimeContext, WindowTimerService<Long> timerService, KeyedStateBackend<RowData> stateBackend, WindowState<Long> windowState, boolean isEventTime) throws Exception {
            NamespaceAggsHandleFunction localAggregator = (NamespaceAggsHandleFunction)this.genLocalAggsHandler.newInstance(runtimeContext.getUserCodeClassLoader());
            NamespaceAggsHandleFunction globalAggregator = (NamespaceAggsHandleFunction)this.genGlobalAggsHandler.newInstance(runtimeContext.getUserCodeClassLoader());
            localAggregator.open(new PerWindowStateDataViewStore(stateBackend, (TypeSerializer<?>)LongSerializer.INSTANCE, runtimeContext));
            globalAggregator.open(new PerWindowStateDataViewStore(stateBackend, (TypeSerializer<?>)LongSerializer.INSTANCE, runtimeContext));
            WindowValueState windowValueState = (WindowValueState)windowState;
            return new GlobalAggCombiner(timerService, arg_0 -> stateBackend.setCurrentKey(arg_0), windowValueState, localAggregator, globalAggregator);
        }
    }
}

