/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import java.io.Serializable;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.apache.flink.util.Preconditions;

public abstract class GeneratedClass<T>
implements Serializable {
    private final String className;
    private final String code;
    private final Object[] references;
    private transient Class<T> compiledClass;

    protected GeneratedClass(String className, String code, Object[] references) {
        Preconditions.checkNotNull((Object)className, (String)"name must not be null");
        Preconditions.checkNotNull((Object)code, (String)"code must not be null");
        Preconditions.checkNotNull((Object)references, (String)"references must not be null");
        this.className = className;
        this.code = code;
        this.references = references;
    }

    public T newInstance(ClassLoader classLoader) {
        try {
            return this.compile(classLoader).getConstructor(Object[].class).newInstance(new Object[]{this.references});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate generated class '" + this.className + "'", e);
        }
    }

    public T newInstance(ClassLoader classLoader, Object ... args) {
        try {
            return (T)this.compile(classLoader).getConstructors()[0].newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate generated class '" + this.className + "'", e);
        }
    }

    public Class<T> compile(ClassLoader classLoader) {
        if (this.compiledClass == null) {
            this.compiledClass = CompileUtils.compile(classLoader, this.className, this.code);
        }
        return this.compiledClass;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getReferences() {
        return this.references;
    }

    public Class<T> getClass(ClassLoader classLoader) {
        return this.compile(classLoader);
    }
}

