/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.table.filesystem.PartitionTempFileManager;
import org.apache.flink.table.filesystem.PartitionWriter;
import org.apache.flink.table.utils.PartitionPathUtils;

@Internal
public class SingleDirectoryWriter<T>
implements PartitionWriter<T> {
    private final PartitionWriter.Context<T> context;
    private final PartitionTempFileManager manager;
    private final PartitionComputer<T> computer;
    private final LinkedHashMap<String, String> staticPartitions;
    private OutputFormat<T> format;

    public SingleDirectoryWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer, LinkedHashMap<String, String> staticPartitions) {
        this.context = context;
        this.manager = manager;
        this.computer = computer;
        this.staticPartitions = staticPartitions;
    }

    private void createFormat() throws IOException {
        this.format = this.context.createNewOutputFormat(this.staticPartitions.size() == 0 ? this.manager.createPartitionDir(new String[0]) : this.manager.createPartitionDir(PartitionPathUtils.generatePartitionPath(this.staticPartitions)));
    }

    @Override
    public void write(T in) throws Exception {
        if (this.format == null) {
            this.createFormat();
        }
        this.format.writeRecord(this.computer.projectColumnsToWrite(in));
    }

    @Override
    public void close() throws Exception {
        if (this.format != null) {
            this.format.close();
            this.format = null;
        }
    }
}

