/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.common;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.plan.logical.MatchRecognize;
import org.apache.flink.table.planner.plan.nodes.FlinkConvention;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalMatch;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.utils.MatchUtil;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public abstract class CommonPhysicalMatchRule
extends ConverterRule {
    public CommonPhysicalMatchRule(Class<? extends RelNode> clazz, RelTrait in, RelTrait out, String descriptionPrefix) {
        super(clazz, in, out, descriptionPrefix);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalMatch logicalMatch = (FlinkLogicalMatch)call.rel(0);
        this.validateAggregations(logicalMatch.getMeasures().values());
        this.validateAggregations(logicalMatch.getPatternDefinitions().values());
        this.validateAmbiguousColumns(logicalMatch);
        return true;
    }

    public RelNode convert(RelNode rel, FlinkConvention convention) {
        FlinkLogicalMatch logicalMatch = (FlinkLogicalMatch)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(convention);
        ImmutableBitSet partitionKeys = logicalMatch.getPartitionKeys();
        FlinkRelDistribution requiredDistribution = partitionKeys.isEmpty() ? FlinkRelDistribution.SINGLETON() : FlinkRelDistribution.hash(logicalMatch.getPartitionKeys().asList(), true);
        RelTraitSet requiredTraitSet = rel.getCluster().getPlanner().emptyTraitSet().replace(requiredDistribution).replace(convention);
        RelNode convertInput = RelOptRule.convert(logicalMatch.getInput(), requiredTraitSet);
        try {
            Class.forName("org.apache.flink.cep.pattern.Pattern", false, ShortcutUtils.unwrapContext(rel).getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new TableException("MATCH RECOGNIZE clause requires flink-cep dependency to be present on the classpath.", (Throwable)e);
        }
        return this.convertToPhysicalMatch(rel.getCluster(), traitSet, convertInput, new MatchRecognize(logicalMatch.getPattern(), logicalMatch.getPatternDefinitions(), logicalMatch.getMeasures(), logicalMatch.getAfter(), logicalMatch.getSubsets(), logicalMatch.isAllRows(), logicalMatch.getPartitionKeys(), logicalMatch.getOrderKeys(), logicalMatch.getInterval()), logicalMatch.getRowType());
    }

    protected abstract RelNode convertToPhysicalMatch(RelOptCluster var1, RelTraitSet var2, RelNode var3, MatchRecognize var4, RelDataType var5);

    private void validateAggregations(Iterable<RexNode> expr) {
        AggregationsValidator validator = new AggregationsValidator();
        expr.forEach(e -> e.accept(validator));
    }

    private void validateAmbiguousColumns(FlinkLogicalMatch logicalMatch) {
        if (logicalMatch.isAllRows()) {
            throw new TableException("All rows per match mode is not supported yet.");
        }
        this.validateAmbiguousColumnsOnRowPerMatch(logicalMatch.getPartitionKeys(), logicalMatch.getMeasures().keySet(), logicalMatch.getInput().getRowType(), logicalMatch.getRowType());
    }

    private void validateAmbiguousColumnsOnRowPerMatch(ImmutableBitSet partitionKeys, Set<String> measuresNames, RelDataType inputSchema, RelDataType expectedSchema) {
        int expectedSize;
        int actualSize = partitionKeys.toArray().length + measuresNames.size();
        if (actualSize != (expectedSize = expectedSchema.getFieldCount())) {
            String ambiguousColumns = Arrays.stream(partitionKeys.toArray()).mapToObj(k -> inputSchema.getFieldList().get(k).getName()).filter(measuresNames::contains).collect(Collectors.joining(", ", "{", "}"));
            throw new ValidationException(String.format("Columns ambiguously defined: %s", ambiguousColumns));
        }
    }

    private static class AggregationsValidator
    extends RexDefaultVisitor<Object> {
        private AggregationsValidator() {
        }

        @Override
        public Object visitCall(RexCall call) {
            SqlOperator operator = call.getOperator();
            if (operator instanceof SqlAggFunction) {
                call.accept(new MatchUtil.AggregationPatternVariableFinder());
            } else {
                call.getOperands().forEach(o -> o.accept(this));
            }
            return null;
        }

        @Override
        public Object visitNode(RexNode rexNode) {
            return null;
        }
    }
}

