/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class ClearQueryBlockAliasResolver
extends RelShuttleImpl {
    public List<RelNode> resolve(List<RelNode> roots) {
        return roots.stream().map(node -> node.accept(this)).collect(Collectors.toList());
    }

    @Override
    protected RelNode visitChild(RelNode parent, int i, RelNode child) {
        RelNode newParent = this.clearQueryBlockAlias(parent);
        return super.visitChild(newParent, i, child);
    }

    @Override
    public RelNode visit(TableScan scan) {
        RelNode newScan = this.clearQueryBlockAlias(scan);
        return super.visit(newScan);
    }

    private RelNode clearQueryBlockAlias(RelNode relNode) {
        if (!(relNode instanceof Hintable)) {
            return relNode;
        }
        ImmutableList<RelHint> hints = ((Hintable)((Object)relNode)).getHints();
        ArrayList<RelHint> newHints = new ArrayList<RelHint>();
        for (RelHint hint : hints) {
            if ("ALIAS".equals(hint.hintName)) continue;
            newHints.add(hint);
        }
        if (newHints.size() != hints.size()) {
            return ((Hintable)((Object)relNode)).withHints(newHints);
        }
        return relNode;
    }
}

