/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecHashJoin;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalJoinBase;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001U\u0011QCQ1uG\"\u0004\u0006._:jG\u0006d\u0007*Y:i\u0015>LgN\u0003\u0002\u0004\t\u0005)!-\u0019;dQ*\u0011QAB\u0001\ta\"L8/[2bY*\u0011q\u0001C\u0001\u0006]>$Wm\u001d\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!!\u0006\"bi\u000eD\u0007\u000b[=tS\u000e\fGNS8j]\n\u000b7/\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u000591\r\\;ti\u0016\u0014\bCA\u000f\"\u001b\u0005q\"BA\u0005 \u0015\t\u0001\u0003#A\u0004dC2\u001c\u0017\u000e^3\n\u0005\tr\"!\u0004*fY>\u0003Ho\u00117vgR,'\u000f\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0003!!(/Y5u'\u0016$\bCA\u000f'\u0013\t9cDA\u0006SK2$&/Y5u'\u0016$\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u000f1,g\r\u001e*fYB\u00111FL\u0007\u0002Y)\u0011QfH\u0001\u0004e\u0016d\u0017BA\u0018-\u0005\u001d\u0011V\r\u001c(pI\u0016D\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\te&<\u0007\u000e\u001e*fY\"A1\u0007\u0001B\u0001B\u0003%A'A\u0005d_:$\u0017\u000e^5p]B\u0011Q\u0007O\u0007\u0002m)\u0011qgH\u0001\u0004e\u0016D\u0018BA\u001d7\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\tU>Lg\u000eV=qKB\u0011Q\bQ\u0007\u0002})\u0011q\bL\u0001\u0005G>\u0014X-\u0003\u0002B}\tY!j\\5o%\u0016dG+\u001f9f\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0015a\u00037fMRL5OQ;jY\u0012,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\b\u0005>|G.Z1o\u0011!a\u0005A!A!\u0002\u0013)\u0015\u0001\u00047fMRL5OQ;jY\u0012\u0004\u0003\u0002\u0003(\u0001\u0005\u000b\u0007I\u0011\u0001#\u0002\u0017%\u001c(I]8bI\u000e\f7\u000f\u001e\u0005\t!\u0002\u0011\t\u0011)A\u0005\u000b\u0006a\u0011n\u001d\"s_\u0006$7-Y:uA!A!\u000b\u0001BC\u0002\u0013\u0005A)A\nuef$\u0015n\u001d;j]\u000e$()^5mIJ{w\u000f\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003F\u0003Q!(/\u001f#jgRLgn\u0019;Ck&dGMU8xA!)a\u000b\u0001C\u0001/\u00061A(\u001b8jiz\"\"\u0002W-[7rkfl\u00181b!\t9\u0002\u0001C\u0003\u001c+\u0002\u0007A\u0004C\u0003%+\u0002\u0007Q\u0005C\u0003*+\u0002\u0007!\u0006C\u00032+\u0002\u0007!\u0006C\u00034+\u0002\u0007A\u0007C\u0003<+\u0002\u0007A\bC\u0003D+\u0002\u0007Q\tC\u0003O+\u0002\u0007Q\tC\u0003S+\u0002\u0007Q\tC\u0004d\u0001\t\u0007I\u0011\u00013\u0002\u0019!\f7\u000f\u001b&pS:$\u0016\u0010]3\u0016\u0003\u0015\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\t)|\u0017N\u001c\u0006\u0003U.\f\u0011b\u001c9fe\u0006$xN]:\u000b\u00051d\u0011a\u0002:v]RLW.Z\u0005\u0003]\u001e\u0014A\u0002S1tQ*{\u0017N\u001c+za\u0016Da\u0001\u001d\u0001!\u0002\u0013)\u0017!\u00045bg\"Tu.\u001b8UsB,\u0007\u0005C\u0003s\u0001\u0011\u00053/\u0001\u0003d_BLHc\u0002;xqjdhp \t\u0003{UL!A\u001e \u0003\t){\u0017N\u001c\u0005\u0006IE\u0004\r!\n\u0005\u0006sF\u0004\r\u0001N\u0001\u000eG>tG-\u001b;j_:,\u0005\u0010\u001d:\t\u000bm\f\b\u0019\u0001\u0016\u0002\t1,g\r\u001e\u0005\u0006{F\u0004\rAK\u0001\u0006e&<\u0007\u000e\u001e\u0005\u0006wE\u0004\r\u0001\u0010\u0005\u0007\u0003\u0003\t\b\u0019A#\u0002\u0019M,W.\u001b&pS:$uN\\3\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b\u0005aQ\r\u001f9mC&tG+\u001a:ngR!\u0011\u0011BA\b!\rY\u00131B\u0005\u0004\u0003\u001ba#!\u0003*fY^\u0013\u0018\u000e^3s\u0011!\t\t\"a\u0001A\u0002\u0005%\u0011A\u00019x\u0011\u001d\t)\u0002\u0001C!\u0003/\tqbY8naV$XmU3mM\u000e{7\u000f\u001e\u000b\u0007\u00033\ty\"a\n\u0011\u0007u\tY\"C\u0002\u0002\u001ey\u0011!BU3m\u001fB$8i\\:u\u0011\u001dY\u00111\u0003a\u0001\u0003C\u00012!HA\u0012\u0013\r\t)C\b\u0002\u000e%\u0016dw\n\u001d;QY\u0006tg.\u001a:\t\u0011\u0005%\u00121\u0003a\u0001\u0003W\t!!\\9\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r-\u0003!iW\r^1eCR\f\u0017\u0002BA\u001b\u0003_\u0011\u0001CU3m\u001b\u0016$\u0018\rZ1uCF+XM]=\t\u0011\u0005e\u0002\u0001\"\u0001\u000f\u0003w\t\u0011c\u001d5vM\u001adWMQ;jY\u0012\u001cu.\u001e8u)\u0011\ti$a\u0011\u0011\u0007\u0019\u000by$C\u0002\u0002B\u001d\u00131!\u00138u\u0011!\tI#a\u000eA\u0002\u0005-\u0002bBA$\u0001\u0011\u0005\u0013\u0011J\u0001\u000eg\u0006$\u0018n\u001d4z)J\f\u0017\u000e^:\u0015\t\u0005-\u0013\u0011\u000b\t\u0005\r\u00065#&C\u0002\u0002P\u001d\u0013aa\u00149uS>t\u0007bBA*\u0003\u000b\u0002\r!J\u0001\u0011e\u0016\fX/\u001b:fIR\u0013\u0018-\u001b;TKRDq!a\u0016\u0001\t\u0013\tI&A\u0012tCRL7OZ=Ue\u0006LGo](o\u001d>t'I]8bI\u000e\f7\u000f\u001e%bg\"Tu.\u001b8\u0015\t\u0005-\u00131\f\u0005\b\u0003'\n)\u00061\u0001&\u0011\u001d\ty\u0006\u0001C!\u0003C\n1\u0003\u001e:b]Nd\u0017\r^3U_\u0016CXm\u0019(pI\u0016$\"!a\u00191\t\u0005\u0015\u0014Q\u000f\t\u0007\u0003O\ni'!\u001d\u000e\u0005\u0005%$bAA6\r\u0005!Q\r_3d\u0013\u0011\ty'!\u001b\u0003\u0011\u0015CXm\u0019(pI\u0016\u0004B!a\u001d\u0002v1\u0001A\u0001DA<\u0003;\n\t\u0011!A\u0003\u0002\u0005e$aA0%cE!\u00111PAA!\r1\u0015QP\u0005\u0004\u0003\u007f:%a\u0002(pi\"Lgn\u001a\t\u0004\r\u0006\r\u0015bAAC\u000f\n\u0019\u0011I\\=\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\u0006\u0011r-\u001a;J]B,H\u000f\u0015:pa\u0016\u0014H/[3t+\t\ti\tE\u0004G\u0003\u001f\u000b\u0019*a%\n\u0007\u0005EuI\u0001\u0004UkBdWM\r\t\u0005\u0003O\n)*\u0003\u0003\u0002\u0018\u0006%$!D%oaV$\bK]8qKJ$\u0018\u0010")
public class BatchPhysicalHashJoin
extends BatchPhysicalJoinBase {
    private final RelOptCluster cluster;
    private final boolean leftIsBuild;
    private final boolean isBroadcast;
    private final boolean tryDistinctBuildRow;
    private final HashJoinType hashJoinType;

    public boolean leftIsBuild() {
        return this.leftIsBuild;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean tryDistinctBuildRow() {
        return this.tryDistinctBuildRow;
    }

    public HashJoinType hashJoinType() {
        return this.hashJoinType;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchPhysicalHashJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftIsBuild(), this.isBroadcast(), this.tryDistinctBuildRow());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("isBroadcast", "true", this.isBroadcast()).item("build", this.leftIsBuild() ? "left" : "right").itemIf("tryDistinctBuildRow", "true", this.tryDistinctBuildRow());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Tuple2 tuple2;
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        double cpuCost = (double)FlinkCost$.MODULE$.HASH_CPU_COST() * (Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt));
        Tuple2 tuple22 = tuple2 = this.leftIsBuild() ? new Tuple2((Object)leftRowCnt, (Object)FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(this.getLeft())) : new Tuple2((Object)rightRowCnt, (Object)FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(this.getRight()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double buildRowCount = (Double)tuple2._1();
        Double buildRowSize = (Double)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)buildRowCount, (Object)buildRowSize);
        Tuple2 tuple24 = tuple23;
        Double buildRowCount2 = (Double)tuple24._1();
        Double buildRowSize2 = (Double)tuple24._2();
        double bucketSize = Predef$.MODULE$.Double2double(buildRowCount2) * (double)8 / (double)FlinkCost$.MODULE$.HASH_COLLISION_WEIGHT();
        double recordSize = Predef$.MODULE$.Double2double(buildRowCount2) * (Predef$.MODULE$.Double2double(buildRowSize2) + (double)4);
        double memCost = (bucketSize + recordSize) * (double)this.shuffleBuildCount(mq);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount(this)), cpuCost, 0.0, 0.0, memCost);
    }

    public int shuffleBuildCount(RelMetadataQuery mq) {
        int n;
        RelNode probeRel;
        RelNode relNode = probeRel = this.leftIsBuild() ? this.getRight() : this.getLeft();
        if (this.isBroadcast()) {
            double rowCount = Util.first(mq.getRowCount(probeRel), 1.0);
            double shuffleCount = rowCount * Predef$.MODULE$.Double2double(mq.getAverageRowSize(probeRel)) / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE();
            n = Math.max(1, (int)shuffleCount);
        } else {
            n = 1;
        }
        return n;
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return !this.isBroadcast() ? this.satisfyTraitsOnNonBroadcastHashJoin(requiredTraitSet) : this.satisfyTraitsOnBroadcastJoin(requiredTraitSet, this.leftIsBuild());
    }

    private Option<RelNode> satisfyTraitsOnNonBroadcastHashJoin(RelTraitSet requiredTraitSet) {
        FlinkRelDistribution requiredDistribution = requiredTraitSet.getTrait(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE());
        Tuple3<Object, FlinkRelDistribution, FlinkRelDistribution> tuple3 = this.satisfyHashDistributionOnNonBroadcastJoin(requiredDistribution);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        boolean canSatisfyDistribution = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        FlinkRelDistribution leftRequiredDistribution = (FlinkRelDistribution)tuple3._2();
        FlinkRelDistribution rightRequiredDistribution = (FlinkRelDistribution)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)canSatisfyDistribution), (Object)leftRequiredDistribution, (Object)rightRequiredDistribution);
        Tuple3 tuple33 = tuple32;
        boolean canSatisfyDistribution2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
        FlinkRelDistribution leftRequiredDistribution2 = (FlinkRelDistribution)tuple33._2();
        FlinkRelDistribution rightRequiredDistribution2 = (FlinkRelDistribution)tuple33._3();
        if (!canSatisfyDistribution2) {
            return None$.MODULE$;
        }
        Function1 & Serializable & scala.Serializable toRestrictHashDistributionByKeys = (Function1 & Serializable & scala.Serializable)distribution -> this.getCluster().getPlanner().emptyTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL()).replace((RelTrait)distribution);
        RelTraitSet leftRequiredTraits = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)leftRequiredDistribution2);
        RelTraitSet rightRequiredTraits = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)rightRequiredDistribution2);
        RelNode newLeft = RelOptRule.convert(this.getLeft(), leftRequiredTraits);
        RelNode newRight = RelOptRule.convert(this.getRight(), rightRequiredTraits);
        RelTraitSet providedTraits = this.getTraitSet().replace(requiredDistribution);
        return new Some((Object)this.copy(providedTraits, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{newLeft, newRight})))));
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        JoinUtil$.MODULE$.validateJoinSpec(this.joinSpec(), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.left.getRowType()), FlinkTypeFactory$.MODULE$.toLogicalRowType(this.right.getRowType()), JoinUtil$.MODULE$.validateJoinSpec$default$4());
        RelMetadataQuery mq = this.getCluster().getMetadataQuery();
        int leftRowSize = (int)Util.first(mq.getAverageRowSize(this.left), 24.0);
        long leftRowCount = (long)Util.first(mq.getRowCount(this.left), 200000.0);
        int rightRowSize = (int)Util.first(mq.getAverageRowSize(this.right), 24.0);
        long rightRowCount = (long)Util.first(mq.getRowCount(this.right), 200000.0);
        Tuple2<InputProperty, InputProperty> tuple2 = this.getInputProperties();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputProperty leftEdge = (InputProperty)tuple2._1();
        InputProperty rightEdge = (InputProperty)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftEdge, (Object)rightEdge);
        Tuple2 tuple23 = tuple22;
        InputProperty leftEdge2 = (InputProperty)tuple23._1();
        InputProperty rightEdge2 = (InputProperty)tuple23._2();
        return new BatchExecHashJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), this.joinSpec(), leftRowSize, rightRowSize, leftRowCount, rightRowCount, this.leftIsBuild(), this.tryDistinctBuildRow(), leftEdge2, rightEdge2, FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    private Tuple2<InputProperty, InputProperty> getInputProperties() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.isBroadcast()) {
            tuple22 = new Tuple2((Object)InputProperty.BROADCAST_DISTRIBUTION, (Object)InputProperty.ANY_DISTRIBUTION);
        } else {
            Tuple2 tuple23;
            int[] leftKeys = this.joinSpec().getLeftKeys();
            int[] rightKeys = this.joinSpec().getRightKeys();
            Tuple2 tuple24 = tuple23 = this.leftIsBuild() ? new Tuple2((Object)leftKeys, (Object)rightKeys) : new Tuple2((Object)rightKeys, (Object)leftKeys);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            int[] buildKeys = (int[])tuple23._1();
            int[] probeKeys = (int[])tuple23._2();
            Tuple2 tuple25 = new Tuple2((Object)buildKeys, (Object)probeKeys);
            Tuple2 tuple26 = tuple25;
            int[] buildKeys2 = (int[])tuple26._1();
            int[] probeKeys2 = (int[])tuple26._2();
            tuple22 = tuple2 = new Tuple2((Object)InputProperty.hashDistribution(buildKeys2), (Object)InputProperty.hashDistribution(probeKeys2));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputProperty.RequiredDistribution buildRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._1();
        InputProperty.RequiredDistribution probeRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._2();
        Tuple2 tuple27 = new Tuple2((Object)buildRequiredDistribution, (Object)probeRequiredDistribution);
        Tuple2 tuple28 = tuple27;
        InputProperty.RequiredDistribution buildRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple28._1();
        InputProperty.RequiredDistribution probeRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple28._2();
        InputProperty.DamBehavior probeDamBehavior = this.hashJoinType().buildLeftSemiOrAnti() ? InputProperty.DamBehavior.END_INPUT : InputProperty.DamBehavior.PIPELINED;
        InputProperty buildEdge = InputProperty.builder().requiredDistribution(buildRequiredDistribution2).damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build();
        InputProperty probeEdge = InputProperty.builder().requiredDistribution(probeRequiredDistribution2).damBehavior(probeDamBehavior).priority(1).build();
        return this.leftIsBuild() ? new Tuple2((Object)buildEdge, (Object)probeEdge) : new Tuple2((Object)probeEdge, (Object)buildEdge);
    }

    public BatchPhysicalHashJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftIsBuild, boolean isBroadcast, boolean tryDistinctBuildRow) {
        this.cluster = cluster;
        this.leftIsBuild = leftIsBuild;
        this.isBroadcast = isBroadcast;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
        JoinRelType joinRelType = this.getJoinType();
        JoinRelType joinRelType2 = JoinRelType.SEMI;
        JoinRelType joinRelType3 = this.getJoinType();
        JoinRelType joinRelType4 = JoinRelType.ANTI;
        this.hashJoinType = HashJoinType.of((boolean)leftIsBuild, (boolean)this.getJoinType().generatesNullsOnRight(), (boolean)this.getJoinType().generatesNullsOnLeft(), (!(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType2) : joinRelType2 != null) ? 1 : 0) != 0, (!(joinRelType3 != null ? !((Object)((Object)joinRelType3)).equals((Object)joinRelType4) : joinRelType4 != null) ? 1 : 0) != 0);
    }
}

