/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlCreateTableAs;
import org.apache.flink.sql.parser.ddl.SqlCreateTableLike;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.CreateTableASOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.planner.calcite.FlinkCalciteSqlValidator;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.MergeTableLikeUtil;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlToOperationConverter;

class SqlCreateTableConverter {
    private final MergeTableLikeUtil mergeTableLikeUtil;
    private final CatalogManager catalogManager;
    private final Consumer<SqlTableConstraint> validateTableConstraint;

    SqlCreateTableConverter(FlinkCalciteSqlValidator sqlValidator, CatalogManager catalogManager, Function<SqlNode, String> escapeExpression, Consumer<SqlTableConstraint> validateTableConstraint) {
        this.mergeTableLikeUtil = new MergeTableLikeUtil(sqlValidator, escapeExpression);
        this.catalogManager = catalogManager;
        this.validateTableConstraint = validateTableConstraint;
    }

    Operation convertCreateTable(SqlCreateTable sqlCreateTable) {
        sqlCreateTable.getTableConstraints().forEach(this.validateTableConstraint);
        CatalogTable catalogTable = this.createCatalogTable(sqlCreateTable);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateTableOperation(identifier, catalogTable, sqlCreateTable.isIfNotExists(), sqlCreateTable.isTemporary());
    }

    Operation convertCreateTableAS(FlinkPlannerImpl flinkPlanner, SqlCreateTableAs sqlCreateTableAs) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateTableAs.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        PlannerQueryOperation query = (PlannerQueryOperation)SqlToOperationConverter.convert(flinkPlanner, this.catalogManager, sqlCreateTableAs.getAsQuery()).orElseThrow(() -> new TableException("CTAS unsupported node type " + sqlCreateTableAs.getAsQuery().getClass().getSimpleName()));
        CatalogTable catalogTable = this.createCatalogTable(sqlCreateTableAs);
        CreateTableOperation createTableOperation = new CreateTableOperation(identifier, CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(query.getResolvedSchema()).build(), (String)catalogTable.getComment(), (List)catalogTable.getPartitionKeys(), (Map)catalogTable.getOptions()), sqlCreateTableAs.isIfNotExists(), sqlCreateTableAs.isTemporary());
        return new CreateTableASOperation(createTableOperation, Collections.emptyMap(), (QueryOperation)query, false);
    }

    private CatalogTable createCatalogTable(SqlCreateTable sqlCreateTable) {
        Map sourceProperties;
        List<SqlTableLike.SqlTableLikeOption> likeOptions;
        List sourcePartitionKeys;
        TableSchema sourceTableSchema;
        if (sqlCreateTable instanceof SqlCreateTableLike) {
            SqlTableLike sqlTableLike = ((SqlCreateTableLike)sqlCreateTable).getTableLike();
            CatalogTable table = this.lookupLikeSourceTable(sqlTableLike);
            sourceTableSchema = TableSchema.fromResolvedSchema((ResolvedSchema)table.getUnresolvedSchema().resolve(this.catalogManager.getSchemaResolver()));
            sourcePartitionKeys = table.getPartitionKeys();
            likeOptions = sqlTableLike.getOptions();
            sourceProperties = table.getOptions();
        } else {
            sourceTableSchema = TableSchema.builder().build();
            sourcePartitionKeys = Collections.emptyList();
            likeOptions = Collections.emptyList();
            sourceProperties = Collections.emptyMap();
        }
        Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies = this.mergeTableLikeUtil.computeMergingStrategies(likeOptions);
        Map<String, String> mergedOptions = this.mergeOptions(sqlCreateTable, sourceProperties, mergingStrategies);
        Optional<SqlTableConstraint> primaryKey = sqlCreateTable.getFullConstraints().stream().filter(SqlTableConstraint::isPrimaryKey).findAny();
        TableSchema mergedSchema = this.mergeTableLikeUtil.mergeTables(mergingStrategies, sourceTableSchema, sqlCreateTable.getColumnList().getList(), sqlCreateTable.getWatermark().map(Collections::singletonList).orElseGet(Collections::emptyList), primaryKey.orElse(null));
        List<String> partitionKeys = this.mergePartitions(sourcePartitionKeys, sqlCreateTable.getPartitionKeyList(), mergingStrategies);
        this.verifyPartitioningColumnsExist(mergedSchema, partitionKeys);
        String tableComment = sqlCreateTable.getComment().map(comment -> comment.getNlsString().getValue()).orElse(null);
        return new CatalogTableImpl(mergedSchema, partitionKeys, mergedOptions, tableComment);
    }

    private CatalogTable lookupLikeSourceTable(SqlTableLike sqlTableLike) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(sqlTableLike.getSourceTable().names);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ContextResolvedTable lookupResult = (ContextResolvedTable)this.catalogManager.getTable(identifier).orElseThrow(() -> new ValidationException(String.format("Source table '%s' of the LIKE clause not found in the catalog, at %s", identifier, sqlTableLike.getSourceTable().getParserPosition())));
        if (!(lookupResult.getTable() instanceof CatalogTable)) {
            throw new ValidationException(String.format("Source table '%s' of the LIKE clause can not be a VIEW, at %s", identifier, sqlTableLike.getSourceTable().getParserPosition()));
        }
        return (CatalogTable)lookupResult.getTable();
    }

    private void verifyPartitioningColumnsExist(TableSchema mergedSchema, List<String> partitionKeys) {
        for (String partitionKey : partitionKeys) {
            if (mergedSchema.getTableColumn(partitionKey).isPresent()) continue;
            throw new ValidationException(String.format("Partition column '%s' not defined in the table schema. Available columns: [%s]", partitionKey, Arrays.stream(mergedSchema.getFieldNames()).collect(Collectors.joining("', '", "'", "'"))));
        }
    }

    private List<String> mergePartitions(List<String> sourcePartitionKeys, SqlNodeList derivedPartitionKeys, Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies) {
        return this.mergeTableLikeUtil.mergePartitions(mergingStrategies.get((Object)SqlTableLike.FeatureOption.PARTITIONS), sourcePartitionKeys, derivedPartitionKeys.getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList()));
    }

    private Map<String, String> mergeOptions(SqlCreateTable sqlCreateTable, Map<String, String> sourceProperties, Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies) {
        HashMap<String, String> properties = new HashMap<String, String>();
        sqlCreateTable.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        return this.mergeTableLikeUtil.mergeOptions(mergingStrategies.get((Object)SqlTableLike.FeatureOption.OPTIONS), sourceProperties, properties);
    }
}

