/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class StringToDecimalCastRule
extends AbstractExpressionCodeGeneratorCastRule<StringData, DecimalData> {
    static final StringToDecimalCastRule INSTANCE = new StringToDecimalCastRule();

    private StringToDecimalCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.CHARACTER_STRING).target(LogicalTypeRoot.DECIMAL).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        DecimalType targetDecimalType = (DecimalType)targetLogicalType;
        return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_DECIMAL(), inputTerm, targetDecimalType.getPrecision(), targetDecimalType.getScale());
    }

    @Override
    public boolean canFail(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return true;
    }
}

