/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.typeutils.Types$;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendRowDataSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.MapDataSerializerTest;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001'\tQ1)\u00197d\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0007gR\u0014X-Y7\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0015)H/\u001b7t\u0013\tIbCA\tTiJ,\u0017-\\5oOR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011A\u0011\u0002\u001dU\u001cXm\u001d'fO\u0006\u001c\u0017PU8xgV\t!\u0005\u0005\u0002$K5\tAE\u0003\u0002\u0018\u0015%\u0011a\u0005\n\u0002\u0012\u0019\u0016<\u0017mY=S_^\u0014Vm]8ve\u000e,\u0007FA\u0010)!\tIC&D\u0001+\u0015\tY\u0003#A\u0003kk:LG/\u0003\u0002.U\t!!+\u001e7f\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0005\"Xm\u001d;TK2,7\r^,ji\"dUmZ1ds\u000e\u000b7\u000f^%oiR{G)\u0019;f)\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001B+oSRD#A\f\u001d\u0011\u0005%J\u0014B\u0001\u001e+\u0005\u0011!Vm\u001d;\t\u000bq\u0002A\u0011\u0001\u0019\u0002GQ,7\u000f^\"bgRtU/\\3sS\u000e$vNQ8pY\u0016\fg.\u00138D_:$\u0017\u000e^5p]\"\u00121\b\u000f\u0005\u0006\u007f\u0001!\t\u0001M\u0001\u0019i\u0016\u001cHoR3oKJL7MU8x\u0003:$'k\\<ECR\f\u0007F\u0001 9\u0011\u0015\u0011\u0005\u0001\"\u00011\u0003E!Xm\u001d;S_^\fe\u000e\u001a*po\u0012\u000bG/\u0019\u0015\u0003\u0003bBQ!\u0012\u0001\u0005\u0002A\nA\u0003^3ti\u001e+g.\u001a:jGJ{w/\u00118e%><\bF\u0001#9\u0011\u0015A\u0005\u0001\"\u00011\u00035!Xm\u001d;S_^\fe\u000e\u001a*po\"\u0012q\t\u000f\u0005\u0006\u0017\u0002!\t\u0001M\u0001\u0015i\u0016\u001cH\u000f\u0015:j[&$\u0018N^3NCB$\u0016\u0010]3)\u0005)C\u0004\"\u0002(\u0001\t\u0003\u0001\u0014a\u0006;fgRtuN\u001c)sS6LG/\u001b<f\u001b\u0006\u0004H+\u001f9fQ\ti\u0005\bC\u0003R\u0001\u0011\u0005\u0001'A\u000fuKN$8+\u001a7fGR\u001cF/\u0019:Ge>lg*Z:uK\u0012$\u0016M\u00197fQ\t\u0001\u0006\bC\u0003U\u0001\u0011\u0005\u0001'\u0001\u0004uKN$\u0018J\u001c\u0015\u0003'bBQa\u0016\u0001\u0005\u0002A\n\u0011\u0002^3ti:{G/\u00138)\u0005YC\u0004\"\u0002.\u0001\t\u0003\u0001\u0014A\u0006;fgRduN\\4Qe>TWm\u0019;j_:d\u0015n\u001d;)\u0005eC\u0004\"B/\u0001\t\u0003\u0001\u0014\u0001\t;fgR\u001cv.\u001e:dK^KG\u000f[\"vgR|W.\u00138uKJt\u0017\r\u001c#bi\u0006D#\u0001\u0018\u001d\t\u000b\u0001\u0004A\u0011\u0001\u0019\u0002#Q,7\u000f^*j[BdW\r\u0015:pU\u0016\u001cG\u000f\u000b\u0002`q!)1\r\u0001C\u0001a\u0005\tB/Z:u\u001d\u0016\u001cH/\u001a3Qe>TWm\u0019;)\u0005\tD\u0004\"\u00024\u0001\t\u0003\u0001\u0014A\n;fgR$UmY5nC2\f%O]1z/&$\b\u000eR5gM\u0016\u0014XM\u001c;Qe\u0016\u001c\u0017n]5p]\"\u0012Q\r\u000f\u0005\u0006S\u0002!\t\u0001M\u0001%i\u0016\u001cH\u000fR3dS6\fG.T1q/&$\b\u000eR5gM\u0016\u0014XM\u001c;Qe\u0016\u001c\u0017n]5p]\"\u0012\u0001\u000e\u000f\u0005\u0006Y\u0002!\t\u0001M\u0001\u0015i\u0016\u001cHoQ;se\u0016tGoV1uKJl\u0017M]6)\u0005-D\u0004\"B8\u0001\t\u0003\u0001\u0014A\u000b;fgR\u001cUO\u001d:f]R<\u0016\r^3s[\u0006\u00148NR8s\u001d>t'k\\<uS6,\u0017\t\u001e;sS\n,H/\u001a\u0015\u0003]bBQA\u001d\u0001\u0005\u0002A\na\u0005^3ti\u000e\u0013X-\u0019;f)\u0016l\u0007o\u001c:bef$\u0016M\u00197f\rJ|W\u000eR3tGJL\u0007\u000f^8sQ\t\t\b\bC\u0003v\u0001\u0011\u0005\u0001'\u0001\u0006uKN$8+Z1sG\"D#\u0001\u001e\u001d\t\u000ba\u0004A\u0011\u0001\u0019\u0002+Q,7\u000f^'vYRL\u0007\u000f\\3D_\u0006dWm]2fg\"\u0012q\u000f\u000f\u0005\u0006w\u0002!\t\u0001M\u0001\u0014i\u0016\u001cHoQ;se\u0016tG\u000fR1uC\n\f7/\u001a\u0015\u0003ub\u0002")
public class CalcITCase
extends StreamingTestBase {
    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testSelectWithLegacyCastIntToDate() {
        this.tEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR, (Object)ExecutionConfigOptions.LegacyCastBehaviour.ENABLED);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT CASE WHEN true THEN CAST(2 AS INT) ELSE CAST('2017-12-11' AS DATE) END")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1970-01-03", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCastNumericToBooleanInCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT * FROM MyTableRow WHERE b = CAST(1 AS BOOLEAN)\n         | UNION ALL\n         | SELECT * FROM MyTableRow WHERE b = CAST(0 AS BOOLEAN)\n         |")).stripMargin();
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData1.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToInteger((int)2));
        rowData2.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        .colon.colon data = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        InternalTypeInfo dataType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)dataType);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,true)", (List)new .colon.colon((Object)"+I(2,false)", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,1,1)", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, VarCharType.STRING_TYPE, new IntType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(Hello,Worlds,1)", (List)new .colon.colon((Object)"+I(Hello again,Worlds,2)", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,1", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream((TypeInformation)tpe);
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Hello,Worlds,1", (List)new .colon.colon((Object)"Hello again,Worlds,2", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[b, 30, 10, a] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=30, 10=1}", (List)new .colon.colon((Object)"{2=30, 10=2}", (List)new .colon.colon((Object)"{2=30, 10=3}", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[a, c] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=Hi}", (List)new .colon.colon((Object)"{2=Hello}", (List)new .colon.colon((Object)"{3=Hello world}", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSelectStarFromNestedTable() {
        String sqlQuery = "SELECT * FROM MyTable";
        Table table = this.tEnv().fromDataStream(this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)"0"), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)"1"), new Tuple2((Object)new Tuple2.mcII.sp(2, 2), (Object)"2")})), (TypeInformation)new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2"))}));
        this.tEnv().registerTable("MyTable", table);
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        table.executeInsert("MySink").await();
        .colon.colon expected = new .colon.colon((Object)"0,0,0", (List)new .colon.colon((Object)"1,1,1", (List)new .colon.colon((Object)"2,2,2", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "4,3,Hello world, how are you?", "5,3,I am fine.", "6,3,Luke Skywalker", "7,4,Comment#1", "8,4,Comment#2", "9,4,Comment#3", "10,4,Comment#4", "11,5,Comment#5", "12,5,Comment#6", "13,5,Comment#7", "14,5,Comment#8", "15,5,Comment#9", "16,6,Comment#10", "17,6,Comment#11", "18,6,Comment#12", "19,6,Comment#13", "20,6,Comment#14", "21,6,Comment#15"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNotIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b not in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLongProjectionList() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        String selectList = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> CalcITCase.$anonfun$testLongProjectionList$1(BoxesRunTime.unboxToInt((Object)i)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        String sqlQuery = new StringBuilder(20).append("select ").append(selectList).append(" from MyTable").toString();
        DataStream result2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result2.addSink((SinkFunction)sink);
        this.env().execute();
        String expected = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$1 -> CalcITCase.$anonfun$testLongProjectionList$2(BoxesRunTime.unboxToInt((Object)x$1)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        Assert.assertEquals((long)sink.getAppendResults().size(), (long)TestData$.MODULE$.smallTupleData3().size());
        sink.getAppendResults().foreach((Function1 & Serializable & scala.Serializable)result -> {
            CalcITCase.$anonfun$testLongProjectionList$3(expected, result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSourceWithCustomInternalData() {
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToLong((long)1L));
        rowData1.setField(1, (Object)CalcITCase.createMapData$1(1L, 2L));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToLong((long)2L));
        rowData2.setField(1, (Object)CalcITCase.createMapData$1(4L, 5L));
        .colon.colon values = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        String myTableDataId = TestValuesTableFactory.registerRowData((Seq<RowData>)values);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n         |CREATE TABLE CustomTable (\n         |  a bigint,\n         |  b map<bigint, bigint>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'register-internal-data' = 'true',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.env().getConfig().disableObjectReuse();
        this.tEnv().executeSql(ddl);
        TableResult result = this.tEnv().executeSql("select a, b from CustomTable");
        .colon.colon expected = new .colon.colon((Object)"1,{1=2}", (List)new .colon.colon((Object)"2,{4=5}", (List)Nil$.MODULE$));
        Buffer actual = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(CollectionUtil.iteratorToList((Iterator)result.collect())).map((Function1 & Serializable & scala.Serializable)r -> r.toString(), Buffer$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleProject() {
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(233).append("\n         |CREATE TABLE SimpleTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select a, c from SimpleTable")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,Hi", (List)new .colon.colon((Object)"2,Hello", (List)new .colon.colon((Object)"3,Hello world", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HI", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)111), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hi", BoxesRunTime.boxToInteger((int)1111)})), "tom"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)222), BoxesRunTime.boxToBoolean((boolean)false)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello", BoxesRunTime.boxToInteger((int)2222)})), "mary"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO WORLD", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)333), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello world", BoxesRunTime.boxToInteger((int)3333)})), "benji"}))}));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(448).append("\n         |CREATE TABLE NestedTable (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'false',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |from NestedTable\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,HI,1111,true,111", (List)new .colon.colon((Object)"2,HELLO,2222,false,222", (List)new .colon.colon((Object)"3,HELLO WORLD,3333,true,333", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        String sqlQuery = "SELECT ARRAY[0.12, 0.5, 0.99]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"[0.12, 0.50, 0.99]", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        String sqlQuery = "SELECT Map['a', 0.12, 'b', 0.5]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{a=0.12, b=0.50}", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentWatermark() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Instant.ofEpochSecond(644326662L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Instant.ofEpochSecond(1622466300L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Instant.ofEpochSecond(1622466300L)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().getConfig().set("table.local-time-zone", "Europe/Berlin");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n                       |CREATE TABLE T (\n                       |  id INT,\n                       |  ts TIMESTAMP_LTZ(3),\n                       |  WATERMARK FOR ts AS ts\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().from("T").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.$("id"), org.apache.flink.table.api.package$.MODULE$.currentWatermark(org.apache.flink.table.api.package$.MODULE$.$("ts"))}).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result1), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT id, CURRENT_WATERMARK(ts) FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result2), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result3 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT id FROM T WHERE CURRENT_WATERMARK(ts) IS NULL OR ts > CURRENT_WATERMARK(ts)\n          |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result3), (String)new StringOps(Predef$.MODULE$.augmentString("1\n        |2\n        |")).stripMargin());
        List result4 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                  |SELECT\n                  |  TUMBLE_END(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |FROM T\n                  |GROUP BY\n                  |  TUMBLE(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result4), (String)new StringOps(Predef$.MODULE$.augmentString("1990-06-02T13:37:43,null\n        |2021-05-31T15:05:01,1990-06-02T11:37:42Z\n        |2021-05-31T15:05:01,2021-05-31T13:05:00Z\n        |")).stripMargin());
    }

    @Test
    public void testCurrentWatermarkForNonRowtimeAttribute() {
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                       |CREATE TABLE T (\n                       |  ts TIMESTAMP_LTZ(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        try {
            this.tEnv().sqlQuery("SELECT CURRENT_WATERMARK(ts) FROM T");
            Assert.fail((String)"CURRENT_WATERMARK for a non-rowtime attribute should have failed.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"SQL validation failed. Invalid function call:\nCURRENT_WATERMARK(TIMESTAMP_LTZ(3))", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTemporaryTableFromDescriptor() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().createTemporaryTable("T", TableDescriptor.forConnector((String)"values").schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build()).option("data-id", tableId).option("bounded", "true").build());
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT * FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"42");
    }

    @Test
    public void testSearch() {
        DataStream stream = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HC809", "H389N     "}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        this.tEnv().createTemporaryView("SimpleTable", stream, Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT upper(f0) from SimpleTable where upper(f0) in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"HC809", (List)new .colon.colon((Object)"H389N     ", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultipleCoalesces() {
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT COALESCE(1),\nCOALESCE(1, 2),\nCOALESCE(cast(NULL as int), 2),\nCOALESCE(1, cast(NULL as int)),\nCOALESCE(cast(NULL as int), cast(NULL as int), 3),\nCOALESCE(4, cast(NULL as int), cast(NULL as int), cast(NULL as int)),\nCOALESCE('1'),\nCOALESCE('1', '23'),\nCOALESCE(cast(NULL as varchar), '2'),\nCOALESCE('1', cast(NULL as varchar)),\nCOALESCE(cast(NULL as varchar), cast(NULL as varchar), '3'),\nCOALESCE('4', cast(NULL as varchar), cast(NULL as varchar), cast(NULL as varchar)),\nCOALESCE(1.0),\nCOALESCE(1.0, 2),\nCOALESCE(cast(NULL as double), 2.0),\nCOALESCE(cast(NULL as double), 2.0, 3.0),\nCOALESCE(2.0, cast(NULL as double), 3.0),\nCOALESCE(cast(NULL as double), cast(NULL as double))").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"1,1,2,1,3,4,1,1,2,1,3,4,1.0,1.0,2.0,2.0,2.0,null");
    }

    @Test
    public void testCurrentDatabase() {
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()}))})), (Object)result1);
        ((Catalog)this.tEnv().getCatalog(this.tEnv().getCurrentCatalog()).get()).createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), "db1"), false);
        this.tEnv().useDatabase("db1");
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()}))})), (Object)result2);
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$1(int i) {
        return new StringBuilder(67).append("CASE WHEN a IS NOT NULL AND a > ").append(i).append(" THEN 0 WHEN a < 0 THEN 0 ELSE ").append(i).append(" END").toString();
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$2(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    public static final /* synthetic */ void $anonfun$testLongProjectionList$3(String expected$1, String result) {
        Assert.assertEquals((Object)expected$1, (Object)result);
    }

    private static final MapData createMapData$1(long k, long v) {
        HashMap<Long, Long> mapData = new HashMap<Long, Long>();
        mapData.put(BoxesRunTime.boxToLong((long)k), BoxesRunTime.boxToLong((long)v));
        return new MapDataSerializerTest.CustomMapData(mapData);
    }
}

