/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.harness;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.harness.HarnessTestBase;
import org.apache.flink.table.planner.runtime.harness.WindowTableFunctionHarnessTest$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001E\u0011adV5oI><H+\u00192mK\u001a+hn\u0019;j_:D\u0015M\u001d8fgN$Vm\u001d;\u000b\u0005\r!\u0011a\u00025be:,7o\u001d\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001f!\u000b'O\\3tgR+7\u000f\u001e\"bg\u0016D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bE\u0006\u001c7.\u001a8e!\tIrF\u0004\u0002\u001bY9\u00111D\u000b\b\u00039%r!!\b\u0015\u000f\u0005y9cBA\u0010'\u001d\t\u0001SE\u0004\u0002\"I5\t!E\u0003\u0002$!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002,\t\u0005)Q\u000f^5mg&\u0011QFL\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/\u001a\u0006\u0003W\u0011I!\u0001M\u0019\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'BA\u0017/\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014!D:iS\u001a$H+[7f5>tW\r\u0005\u00026u5\taG\u0003\u00028q\u0005!A/[7f\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\ri{g.Z%e\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q\u0019q\bQ!\u0011\u0005M\u0001\u0001\"B\f=\u0001\u0004A\u0002\"B\u001a=\u0001\u0004!\u0004bB\"\u0001\u0005\u0004%I\u0001R\u0001\f+R\u001buLW(O\u000b~KE)F\u00015\u0011\u00191\u0005\u0001)A\u0005i\u0005aQ\u000bV\"`5>sUiX%EA!9\u0001\n\u0001b\u0001\n\u0013I\u0015\u0001C1tg\u0016\u0014Ho\u001c:\u0016\u0003)\u0003\"aS(\u000e\u00031S!!\u0014(\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b!I!\u0001\u0015'\u0003-I{w\u000fR1uC\"\u000b'O\\3tg\u0006\u001b8/\u001a:u_JDaA\u0015\u0001!\u0002\u0013Q\u0015!C1tg\u0016\u0014Ho\u001c:!\u0011\u0015!\u0006\u0001\"\u0011V\u0003\u0019\u0011WMZ8sKR\ta\u000b\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0003V]&$\bFA*^!\tq\u0016-D\u0001`\u0015\t\u0001g\"A\u0003kk:LG/\u0003\u0002c?\n1!)\u001a4pe\u0016DQ\u0001\u001a\u0001\u0005\u0002U\u000ba\u0004^3tiB\u0013xnY3tg&tw\rV5nKR+XN\u00197f/&tGm\\<)\u0005\r4\u0007C\u00010h\u0013\tAwL\u0001\u0003UKN$\b\"\u00026\u0001\t\u0003)\u0016a\u0007;fgR\u0004&o\\2fgNLgn\u001a+j[\u0016Du\u000e],j]\u0012|w\u000f\u000b\u0002jM\")Q\u000e\u0001C\u0001+\u0006\u0001C/Z:u!J|7-Z:tS:<G+[7f\u0007VlW\u000f\\1uK^Kg\u000eZ8xQ\tag\rC\u0003q\u0001\u0011%\u0011/\u0001\u0006j]\u001e,7\u000f\u001e#bi\u0006$\"A\u0016:\t\u000bM|\u0007\u0019\u0001;\u0002\u0017Q,7\u000f\u001e%be:,7o\u001d\t\u0005kf\\80D\u0001w\u0015\tiuO\u0003\u0002y\u0015\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003uZ\u0014\u0011e\u00148f\u0013:\u0004X\u000f^*ue\u0016\fWn\u00149fe\u0006$xN\u001d+fgRD\u0015M\u001d8fgN\u0004\"\u0001`@\u000e\u0003uT!A \u0005\u0002\t\u0011\fG/Y\u0005\u0004\u0003\u0003i(a\u0002*po\u0012\u000bG/\u0019\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0003\u0019\u0011XmY8sIR!\u0011\u0011BA\f!\u0015\tY!a\u0005|\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001D:ue\u0016\fWN]3d_J$'BA\u0003x\u0013\u0011\t)\"!\u0004\u0003\u0019M#(/Z1n%\u0016\u001cwN\u001d3\t\u0011\u0005e\u00111\u0001a\u0001\u00037\tA!\u0019:hgB)q+!\b\u0002\"%\u0019\u0011q\u0004-\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002X\u0003GI1!!\nY\u0005\r\te.\u001f\u0005\b\u0003S\u0001A\u0011BA\u0016\u0003)awnY1m\u001b&dGn\u001d\u000b\u0005\u0003[\t\u0019\u0004E\u0002}\u0003_I1!!\r~\u00055!\u0016.\\3ti\u0006l\u0007\u000fR1uC\"A\u0011QGA\u0014\u0001\u0004\t9$\u0001\u0005eCR,G+[7f!\u0011\tI$!\u0011\u000f\t\u0005m\u0012Q\b\t\u0003CaK1!a\u0010Y\u0003\u0019\u0001&/\u001a3fM&!\u00111IA#\u0005\u0019\u0019FO]5oO*\u0019\u0011q\b-\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u0005)Q.\u001b7mgR!\u0011QFA'\u0011!\t)$a\u0012A\u0002\u0005]\u0002f\u0002\u0001\u0002R\u0005u\u0013q\f\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011qK0\u0002\rI,hN\\3s\u0013\u0011\tY&!\u0016\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM0\u0002\u000fI,hN\\3sg&!\u00111NA3\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e9\u0011q\u000e\u0002\t\u0002\u0005E\u0014AH,j]\u0012|w\u000fV1cY\u00164UO\\2uS>t\u0007*\u0019:oKN\u001cH+Z:u!\r\u0019\u00121\u000f\u0004\u0007\u0003\tA\t!!\u001e\u0014\t\u0005M\u0014q\u000f\t\u0004/\u0006e\u0014bAA>1\n1\u0011I\\=SK\u001aDq!PA:\t\u0003\ty\b\u0006\u0002\u0002r!A\u00111QA:\t\u0003\t))\u0001\u0006qCJ\fW.\u001a;feN$\"!a\"\u0011\r\u0005%\u0015QRAI\u001b\t\tYI\u0003\u0002Nq%!\u0011qRAF\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0006/\u0006M\u0015qS\u0005\u0004\u0003+C&!B!se\u0006L\b\u0003BAM\u0003?k!!a'\u000b\u0007\u0005u\u0005(\u0001\u0003mC:<\u0017\u0002BAQ\u00037\u0013aa\u00142kK\u000e$\b\u0006CAA\u0003K\u000b\u0019,!.\u0011\t\u0005\u001d\u0016Q\u0016\b\u0005\u0003G\nI+\u0003\u0003\u0002,\u0006\u0015\u0014!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u00020\u0006E&A\u0003)be\u0006lW\r^3sg*!\u00111VA3\u0003\u0011q\u0017-\\3\"\u0005\u0005]\u0016AH*uCR,')Y2lK:$Wh\u001f\u0019~Y\u0001\"\u0016.\\3[_:,Wh_\u0019~\u0001")
public class WindowTableFunctionHarnessTest
extends HarnessTestBase {
    private final ZoneId shiftTimeZone;
    private final ZoneId UTC_ZONE_ID;
    private final RowDataHarnessAssertor assertor;

    @Parameterized.Parameters(name="StateBackend={0}, TimeZone={1}")
    public static Collection<Object[]> parameters() {
        return WindowTableFunctionHarnessTest$.MODULE$.parameters();
    }

    private ZoneId UTC_ZONE_ID() {
        return this.UTC_ZONE_ID;
    }

    private RowDataHarnessAssertor assertor() {
        return this.assertor;
    }

    @Override
    @Before
    public void before() {
        super.before();
        String dataId = TestValuesTableFactory.registerData(TestData$.MODULE$.windowDataWithTimestamp());
        this.tEnv().getConfig().setLocalTimeZone(this.shiftTimeZone);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(551).append("\n                       |CREATE TABLE T1 (\n                       | `ts` STRING,\n                       | `int` INT,\n                       | `double` DOUBLE,\n                       | `float` FLOAT,\n                       | `bigdec` DECIMAL(10, 2),\n                       | `string` STRING,\n                       | `name` STRING,\n                       | proctime AS PROCTIME()\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testProcessingTimeTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM TABLE(TUMBLE(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testProcessingTimeHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM TABLE(\n        |  HOP(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND, INTERVAL '10' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1969-12-31T23:59:55"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:05"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:10"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25"), this.mills("1970-01-01T00:00:24.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:25"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testProcessingTimeCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM TABLE(\n        |  CUMULATE(TABLE T1, DESCRIPTOR(proctime), INTERVAL '5' SECOND, INTERVAL '15' SECOND))\n      ")).stripMargin();
        Table t1 = this.tEnv().sqlQuery(sql);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createHarnessTesterForNoState(package$.MODULE$.tableConversions(t1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)), "WindowTableFunction");
        testHarness.open();
        this.ingestData(testHarness);
        ConcurrentLinkedQueue<StreamRecord<RowData>> expected = new ConcurrentLinkedQueue<StreamRecord<RowData>>();
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:05"), this.mills("1970-01-01T00:00:04.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null, this.localMills("1970-01-01T00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:10"), this.mills("1970-01-01T00:00:09.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null, this.localMills("1970-01-01T00:00:00"), this.localMills("1970-01-01T00:00:15"), this.mills("1970-01-01T00:00:14.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:20"), this.mills("1970-01-01T00:00:19.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:25"), this.mills("1970-01-01T00:00:24.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null, this.localMills("1970-01-01T00:00:15"), this.localMills("1970-01-01T00:00:30"), this.mills("1970-01-01T00:00:29.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45"), this.mills("1970-01-01T00:00:44.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:35"), this.mills("1970-01-01T00:00:34.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:40"), this.mills("1970-01-01T00:00:39.999")})));
        expected.add(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null, this.localMills("1970-01-01T00:00:30"), this.localMills("1970-01-01T00:00:45"), this.mills("1970-01-01T00:00:44.999")})));
        this.assertor().assertOutputEqualsSorted("result mismatch", expected, (Collection)testHarness.getOutput());
        testHarness.close();
    }

    private void ingestData(OneInputStreamOperatorTestHarness<RowData, RowData> testHarness) {
        testHarness.setProcessingTime(1000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)1.0), "Hi", null})));
        testHarness.setProcessingTime(2000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(3000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)2.0), "Comment#1", null})));
        testHarness.setProcessingTime(4000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), null, null})));
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", BoxesRunTime.boxToDouble((double)5.0), "Hi", null})));
        testHarness.setProcessingTime(6000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)6.0), "Hi", null})));
        testHarness.setProcessingTime(7000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Hello", null})));
        testHarness.setProcessingTime(8000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a", null, "Comment#2", null})));
        testHarness.setProcessingTime(16000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)4.0), "Hi", null})));
        testHarness.setProcessingTime(32000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToDouble((double)7.0), null, null})));
        testHarness.setProcessingTime(34000L);
        testHarness.processElement(this.record((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b", BoxesRunTime.boxToDouble((double)3.0), "Comment#3", null})));
        testHarness.setProcessingTime(50000L);
    }

    private StreamRecord<RowData> record(Seq<Object> args) {
        Object[] objs = (Object[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object2);
                object = BoxesRunTime.boxToLong((long)l);
            } else if (object2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object2);
                object = BoxesRunTime.boxToDouble((double)d);
            } else {
                object = object2;
            }
            return object;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        return StreamRecordUtils.binaryRecord((RowKind)RowKind.INSERT, (Object[])objs);
    }

    private TimestampData localMills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)TimeWindowUtil.toUtcTimestampMills((long)windowDateTime.toInstant().toEpochMilli(), (ZoneId)this.shiftTimeZone));
    }

    private TimestampData mills(String dateTime) {
        ZonedDateTime windowDateTime = LocalDateTime.parse(dateTime).atZone(this.UTC_ZONE_ID());
        return TimestampData.fromEpochMillis((long)windowDateTime.toInstant().toEpochMilli());
    }

    public WindowTableFunctionHarnessTest(StreamingWithStateTestBase.StateBackendMode backend, ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        super(backend);
        this.UTC_ZONE_ID = ZoneId.of("UTC");
        this.assertor = new RowDataHarnessAssertor((LogicalType[])((Object[])new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.DOUBLE().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType(), DataTypes.TIMESTAMP_LTZ((int)3).getLogicalType()}));
    }
}

