/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001I\u0011!cU3u\u001fB,'/\u0019;peNLEkQ1tK*\u00111\u0001B\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000b\u0019\tQAY1uG\"T!a\u0002\u0005\u0002\u000fI,h\u000e^5nK*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\t\u00191B\u0003\u0002\r\u001b\u0005)a\r\\5oW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005Y1\u0011!B;uS2\u001c\u0018B\u0001\r\u0016\u00055\u0011\u0015\r^2i)\u0016\u001cHOQ1tK\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011A\u0001\u0005\u0006?\u0001!\t\u0001I\u0001\u000fkN,7\u000fT3hC\u000eL(k\\<t+\u0005\t\u0003C\u0001\u0012%\u001b\u0005\u0019#B\u0001\f\u000b\u0013\t)3EA\tMK\u001e\f7-\u001f*poJ+7o\\;sG\u0016D#AH\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005)z\u0011!\u00026v]&$\u0018B\u0001\u0017*\u0005\u0011\u0011V\u000f\\3\t\u000f9\u0002!\u0019!C\u0001_\u0005\u0001R\r\u001f9fGR,GMS8j]RK\b/Z\u000b\u0002aA\u0011\u0011'\u0014\b\u0003e)s!aM$\u000f\u0005Q*eBA\u001bE\u001d\t14I\u0004\u00028\u0005:\u0011\u0001(\u0011\b\u0003s\u0001s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005u\n\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\tqq\"\u0003\u0002\r\u001b%\u00111aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011B\u0001$\u0005\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u0011&\u000bAA[8j]*\u0011a\tB\u0005\u0003\u00172\u000b\u0001BS8j]RK\b/\u001a\u0006\u0003\u0011&K!AT(\u0003\u0011){\u0017N\u001c+za\u0016T!a\u0013'\t\rE\u0003\u0001\u0015!\u00031\u0003E)\u0007\u0010]3di\u0016$'j\\5o)f\u0004X\r\t\u0005\u0006'\u0002!\t\u0005V\u0001\u0007E\u00164wN]3\u0015\u0003U\u0003\"AV-\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u0013A!\u00168ji\"\u0012!\u000b\u0018\t\u0003QuK!AX\u0015\u0003\r\t+gm\u001c:f\u0011\u0015\u0001\u0007\u0001\"\u0001U\u00031!Xm\u001d;V]&|g.\u00117mQ\ty&\r\u0005\u0002)G&\u0011A-\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0003g\u0001\u0011\u0005A+\u0001\u000euKN$XK\\5p]\u0006cGnV5uQ\u000e{W.\\8o)f\u0004X\r\u000b\u0002fE\")\u0011\u000e\u0001C\u0001)\u0006IA/Z:u+:LwN\u001c\u0015\u0003Q\nDQ\u0001\u001c\u0001\u0005\u0002Q\u000b1\u0003^3tiR+'O\\1ssVs\u0017n\u001c8BY2D#a\u001b2\t\u000b=\u0004A\u0011\u0001+\u0002!Q,7\u000f\u001e+fe:\f'/_+oS>t\u0007F\u00018c\u0011\u0015\u0011\b\u0001\"\u0001U\u00031!Xm\u001d;NS:,8/\u00117mQ\t\t(\rC\u0003v\u0001\u0011\u0005A+A\u0005uKN$X*\u001b8vg\"\u0012AO\u0019\u0005\u0006q\u0002!\t\u0001V\u0001\u001di\u0016\u001cH/T5okN$\u0015N\u001a4fe\u0016tGOR5fY\u0012t\u0015-\\3tQ\t9(\rC\u0003|\u0001\u0011\u0005A+A\u0007uKN$\u0018J\u001c;feN,7\r\u001e\u0015\u0003u\nDQA \u0001\u0005\u0002Q\u000b\u0001\u0003^3ti&sG/\u001a:tK\u000e$\u0018\t\u001c7)\u0005u\u0014\u0007BBA\u0002\u0001\u0011\u0005A+\u0001\u0013uKN$\u0018J\u001c;feN,7\r^,ji\"$\u0015N\u001a4fe\u0016tGOR5fY\u0012t\u0015-\\3tQ\r\t\tA\u0019\u0005\u0007\u0003\u0013\u0001A\u0011\u0001+\u0002CQ,7\u000f^%oi\u0016\u00148/Z2u/&$\bnU2bY\u0006\u0014X\t\u001f9sKN\u001c\u0018n\u001c8)\u0007\u0005\u001d!\r")
public class SetOperatorsITCase
extends BatchTestBase {
    private final Enumeration.Value expectedJoinType = JoinType$.MODULE$.SortMergeJoin();

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    @Override
    @Before
    public void before() {
        super.before();
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @Test
    public void testUnionAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "d, e, f");
        Table unionDs = ds1.unionAll(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\nHi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnionAllWithCommonType() {
        Table table1 = this.tEnv().fromValues(new Expression[]{package$.MODULE$.row(package$.MODULE$.int2Literal(12), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("")}))});
        Table table2 = this.tEnv().fromValues(new Expression[]{package$.MODULE$.row(package$.MODULE$.javaDec2Literal(new BigDecimal("1234.123")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("ABC")}))});
        Table unionTable = table1.unionAll(table2);
        List schema = unionTable.getResolvedSchema().getColumnDataTypes();
        Assert.assertThat(schema.get(0), (Matcher)CoreMatchers.equalTo((Object)DataTypes.DECIMAL((int)13, (int)3).notNull()));
        Assert.assertThat(schema.get(1), (Matcher)CoreMatchers.equalTo((Object)DataTypes.VARCHAR((int)3).notNull()));
        Seq<Row> results = this.executeQuery(unionTable);
        String expected = "12.000,\n1234.123,ABC\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testUnion() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "d, e, f");
        Table unionDs = ds1.union(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTernaryUnionAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table unionDs = ds1.unionAll(ds2).unionAll(ds3).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\nHi\nHello\nHello world\nHi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testTernaryUnion() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table unionDs = ds1.union(ds2).union(ds3).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(unionDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinusAll() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2());
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minusAll(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hi\nHello\nHello world\nHello\nHello world\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinus() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minus(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testMinusDifferentFieldNames() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi")}), ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table minusDs = ds1.unionAll(ds1).unionAll(ds1).minus(ds2.unionAll(ds2)).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(minusDs);
        String expected = "Hello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersect() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Hi"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Hello world!"));
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Random$.MODULE$.shuffle((TraversableOnce)data, MutableList$.MODULE$.canBuildFrom()), "a, b, c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.batch.table.SetOperatorsITCase$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table intersectDS = ds1.intersect(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(intersectDS);
        String expected = "Hi\nHello\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectAll() {
        MutableList data1 = new MutableList();
        data1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 2}));
        MutableList data2 = new MutableList();
        data2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 2, 3}));
        Table ds1 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data1, "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table ds2 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data2, "c", ClassTag$.MODULE$.Int(), BasicTypeInfo.getInfoFor(Integer.TYPE));
        Table intersectDS = ds1.intersectAll(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        String expected = "1\n2\n2";
        Seq<Row> results = this.executeQuery(intersectDS);
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectWithDifferentFieldNames() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "e, f, g");
        Table intersectDs = ds1.intersect(ds2).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Seq<Row> results = this.executeQuery(intersectDs);
        String expected = "Hi\nHello\nHello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testIntersectWithScalarExpression() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.int2Literal(1)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.int2Literal(1)), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))});
        Table intersectDs = ds1.intersect(ds2);
        Seq<Row> results = this.executeQuery(intersectDs);
        String expected = "2,1,Hi\n3,2,Hello\n4,2,Hello world\n";
        TestBaseUtils.compareResultAsText((List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

