/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.planner.utils.WithoutTimeAttributesTableSource$;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001'\tyA+\u00192mKN\u001b\u0017M\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!\u00022bi\u000eD'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\ti!)\u0019;dQR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011A\u0011\u0002GQ,7\u000f\u001e+bE2,7k\\;sG\u0016<\u0016\u000e\u001e5pkR$\u0016.\\3BiR\u0014\u0018NY;uKR\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0003V]&$\bFA\u0010*!\tQS&D\u0001,\u0015\ta\u0003#A\u0003kk:LG/\u0003\u0002/W\t!A+Z:u\u0011\u0015\u0001\u0004\u0001\"\u0001\"\u0003]!Xm\u001d;Qe>\u001cG/[7f)\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u00020S!)1\u0007\u0001C\u0001C\u00051B/Z:u%><H/[7f)\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u00023S\u0001")
public class TableScanITCase
extends BatchTestBase {
    @Test
    public void testTableSourceWithoutTimeAttribute() {
        String tableName = "MyTable";
        WithoutTimeAttributesTableSource$.MODULE$.createTemporaryTable(this.tEnv(), tableName);
        this.checkResult(new StringBuilder(14).append("SELECT * from ").append(tableName).toString(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testProctimeTableSource() {
        String tableName = "MyTable";
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary", "Peter", "Bob", "Liz"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "ptime"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.LOCAL_DATE_TIME()}));
        TypeInformation returnType = Types.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(true, schema, returnType, data, null, "ptime", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal(tableName, tableSource);
        this.checkResult(new StringBuilder(70).append("SELECT name, CHAR_LENGTH(DATE_FORMAT(ptime, 'yyyy-MM-dd HH:mm')) FROM ").append(tableName).toString(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", BoxesRunTime.boxToInteger((int)16)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Peter", BoxesRunTime.boxToInteger((int)16)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", BoxesRunTime.boxToInteger((int)16)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz", BoxesRunTime.boxToInteger((int)16)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testRowtimeTableSource() {
        String tableName = "MyTable";
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)1L), new Integer(10)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", DateTimeUtils.toLocalDateTime((long)2L), new Integer(20)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)2L), new Integer(30)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz", DateTimeUtils.toLocalDateTime((long)2001L), new Integer(40)}))}));
        String[] fieldNames = (String[])((Object[])new String[]{"name", "rtime", "amount"});
        TableSchema schema = new TableSchema(fieldNames, (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), LocalTimeTypeInfo.LOCAL_DATE_TIME, Types.INT()}));
        RowTypeInfo rowType = new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), LocalTimeTypeInfo.LOCAL_DATE_TIME, Types.INT()}), fieldNames);
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(true, schema, rowType, data, "rtime", null, TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal(tableName, tableSource);
        this.checkResult(new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString(), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)1L), new Integer(10)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mary", DateTimeUtils.toLocalDateTime((long)2L), new Integer(30)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Bob", DateTimeUtils.toLocalDateTime((long)2L), new Integer(20)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Liz", DateTimeUtils.toLocalDateTime((long)2001L), new Integer(40)}))}))), this.checkResult$default$3());
    }
}

