/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001U\u0011\u0001c\u0012:pkBLgnZ*fiN$Vm\u001d;\u000b\u0005\r!\u0011aA1hO*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0019\u0019HO]3b[*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n\u0013\u0019\u0013\u0001B;uS2,\u0012\u0001\n\t\u0003/\u0015J!A\n\r\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r!\u0002\u0001\u0015!\u0003%\u0003\u0015)H/\u001b7!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003A!Xm\u001d;He>,\b/\u001b8h'\u0016$8\u000fF\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;)\u0005%\u001a\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0013\u0003\u0015QWO\\5u\u0013\tATG\u0001\u0003UKN$\b\"\u0002\u001e\u0001\t\u0003Y\u0013!\u0005;fgR<%o\\;qS:<7+\u001a;te!\u0012\u0011h\r\u0005\u0006{\u0001!\taK\u0001\u0012i\u0016\u001cHo\u0012:pkBLgnZ*fiN\u001c\u0004F\u0001\u001f4\u0011\u0015\u0001\u0005\u0001\"\u0001,\u0003\t\"Xm\u001d;He>,\b/\u001b8h'\u0016$8oT;uaV$8OT;mY\u0006\u0014\u0017\u000e\\5us\"\u0012qh\r\u0005\u0006\u0007\u0002!\taK\u0001\ti\u0016\u001cHoQ;cK\"\u0012!i\r\u0005\u0006\r\u0002!\taK\u0001\u000bi\u0016\u001cHOU8mYV\u0004\bFA#4\u0011\u0015I\u0005\u0001\"\u0001,\u0003}!Xm\u001d;He>,\b/\u001b8h'\u0016$8oV5uQ>sWm\u0012:pkBLgn\u001a\u0015\u0003\u0011NBQ\u0001\u0014\u0001\u0005\u0002-\nQ\u0003^3ti\n\u000b7/[2He>,\b/\u001b8h'\u0016$8\u000f\u000b\u0002Lg!)q\n\u0001C\u0001W\u0005aB/Z:u\u000fJ|W\u000f]5oON+Go](o\u000bb\u0004(/Z:tS>t\u0007F\u0001(4\u0011\u0015\u0011\u0006\u0001\"\u0001,\u00039!Xm\u001d;TS6\u0004H.Z\"vE\u0016D#!U\u001a\t\u000bU\u0003A\u0011A\u0016\u0002'Q,7\u000f\u001e*pY2,\bo\u001482\u0007>dW/\u001c8)\u0005Q\u001b\u0004\"\u0002-\u0001\t\u0003Y\u0013a\u0005;fgR\u0014v\u000e\u001c7va>s'gQ8mk6t\u0007FA,4\u0011\u0015Y\u0006\u0001\"\u0001,\u0003m!Xm\u001d;S_2dW\u000f](o\u0007>dW/\u001c8XSRDg*\u001e7mg\"\u0012!l\r\u0005\u0006=\u0002!\taK\u0001\u0016i\u0016\u001cHOU8mYV\u0004\b\u000b\\;t\u001fJ$WM\u001d\"zQ\ti6\u0007C\u0003b\u0001\u0011\u00051&\u0001\u000euKN$(k\u001c7mkB\u001c\u0015M\u001d;fg&\fg\u000e\u0015:pIV\u001cG\u000f\u000b\u0002ag!)A\r\u0001C\u0001W\u0005\u0019D/Z:u%>dG.\u001e9DCJ$Xm]5b]B\u0013x\u000eZ;di>3w+\u001b;i)V\u0004H.Z,ji\",\u0005\u0010\u001d:fgNLwN\u001c\u0015\u0003GNBQa\u001a\u0001\u0005\u0002-\nA\u0003^3tiJ{G\u000e\\;q/&$\b\u000eS1wS:<\u0007F\u000144\u0011\u0015Q\u0007\u0001\"\u0001,\u0003M!Xm\u001d;Dk\n,\u0017I\u001c3ESN$\u0018N\\2uQ\tI7\u0007C\u0003n\u0001\u0011\u00051&A\buKN$8)\u001e2f\u0003:$'j\\5oQ\ta7\u0007C\u0003q\u0001\u0011\u00051&\u0001\u0015uKN$xI]8va&tw-\u00138TK2,7\r^\"mCV\u001cXm\u00144He>,\bOQ=Rk\u0016\u0014\u0018\u0010\u000b\u0002pg!)1\u000f\u0001C\u0001W\u0005)C/Z:u\u000fJ|W\u000f]5oO&s7+\u001a7fGR\u001cE.Y;tK>37)\u001e2f#V,'/\u001f\u0015\u0003eNBQA\u001e\u0001\u0005\u0002-\n1\b^3ti\u001e\u0013x.\u001e9j]\u001e<%o\\;q?&$wI]8va&twmX5e\u0013:\u001cV\r\\3di\u000ec\u0017-^:f\u001f\u001a<%o\\;q\u0005f\fV/\u001a:zQ\t)8\u0007C\u0003z\u0001\u0011\u00051&\u0001!uKN$xI]8va&tw-Q2dKB$8/T;mi&\u0004H.Z!sOVlWM\u001c;t\u000f&4Xm]*b[\u0016\u0014Vm];mi\u0006\u001bxI]8va&twmX5eQ\tA8\u0007C\u0003}\u0001\u0011\u00051&A\u000euKN$xI]8va&tw-\u00138Pe\u0012,'OQ=DY\u0006,8/\u001a\u0015\u0003wNBQa \u0001\u0005\u0002-\n!\u0005^3ti\u0012+\b\u000f\\5dCR,\u0017I]4v[\u0016tG\u000fV8He>,\b/\u001b8h?&$\u0007F\u0001@4\u0011\u0019\t)\u0001\u0001C\u0001W\u00059C/Z:u\u000fJ|W\u000f]5oO&s7+\u001a7fGR\u001cE.Y;tK>3'k\u001c7mkB\fV/\u001a:zQ\r\t\u0019a\r\u0005\u0007\u0003\u0017\u0001A\u0011A\u0016\u0002EQ,7\u000f^$s_V\u0004\u0018N\\4He>,\b/\u001b8h?&$\u0017I\u001c3He>,\boX5eQ\r\tIa\r\u0005\u0007\u0003#\u0001A\u0011A\u0016\u00029Q,7\u000f^!mY><X\t\u001f9sKN\u001c\u0018n\u001c8J]J{G\u000e\\;qc!\u001a\u0011qB\u001a\t\r\u0005]\u0001\u0001\"\u0001,\u0003i!Xm\u001d;BY2|w/\u0012=qe\u0016\u001c8/[8o\u0013:\u001cUOY32Q\r\t)b\r\u0005\u0007\u0003;\u0001A\u0011A\u0016\u00029Q,7\u000f^!mY><X\t\u001f9sKN\u001c\u0018n\u001c8J]J{G\u000e\\;qe!\u001a\u00111D\u001a\t\r\u0005\r\u0002\u0001\"\u0001,\u0003i!Xm\u001d;BY2|w/\u0012=qe\u0016\u001c8/[8o\u0013:\u001cUOY33Q\r\t\tc\r\u0005\u0007\u0003S\u0001A\u0011A\u0016\u00029Q,7\u000f^!mY><X\t\u001f9sKN\u001c\u0018n\u001c8J]J{G\u000e\\;qg!\u001a\u0011qE\u001a\t\r\u0005=\u0002\u0001\"\u0001,\u0003=!Xm\u001d;D\u00032\u001b\u0015\nV#2qI\"\u0004fAA\u0017g!1\u0011Q\u0007\u0001\u0005\u0002-\n\u0001\u0003^3ti\u001a\u0013x.\u001c\"m_\u001e\u001c\bo\u001c;)\u0007\u0005M2\u0007\u0003\u0004\u0002<\u0001!\taK\u0001\u0017i\u0016\u001cHoQ;cK\u0006\u001bxI]8va&twmU3ug\"\u001a\u0011\u0011H\u001a\t\r\u0005\u0005\u0003\u0001\"\u0001,\u0003a!Xm\u001d;S_2dW\u000f]!t\u000fJ|W\u000f]5oON+Go\u001d\u0015\u0004\u0003\u007f\u0019\u0004bBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u0014m\u0016\u0014\u0018NZ=QY\u0006t\u0017\nZ3oi&\u001c\u0017\r\u001c\u000b\u0006Y\u0005-\u0013Q\r\u0005\t\u0003\u001b\n)\u00051\u0001\u0002P\u0005!1/\u001d72!\u0011\t\t&a\u0018\u000f\t\u0005M\u00131\f\t\u0004\u0003+rSBAA,\u0015\r\tI\u0006F\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005uc&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;r\u0003\u0002CA4\u0003\u000b\u0002\r!a\u0014\u0002\tM\fHN\r")
public class GroupingSetsTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testGroupingSets() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c, AVG(a) AS a, GROUP_ID() AS g FROM MyTable\n        |GROUP BY GROUPING SETS (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSets2() {
        this.util().verifyExecPlan("SELECT b, c, AVG(a) AS a FROM MyTable GROUP BY GROUPING SETS (b, c, ())");
    }

    @Test
    public void testGroupingSets3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid,\n        |    COUNT(*) AS cnt\n        |FROM MyTable\n        |     GROUP BY GROUPING SETS (b, c, ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsOutputsNullability() {
        String sourceDDL = new StringOps(Predef$.MODULE$.augmentString("\n         |create table t1(\n         |  a int,\n         |  b varchar,\n         |  c varchar not null,\n         |  d bigint\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/to/my/path1',\n         |  'format' = 'testcsv'\n         |)\n      ")).stripMargin();
        this.util().tableEnv().executeSql(sourceDDL);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        | a,\n        | b,\n        | coalesce(c, 'empty'),\n        | avg(d)\n        |FROM t1\n        |GROUP BY GROUPING SETS ((a, b), (a, b, c))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCube() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollup() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) AS gic,\n        |    GROUPING_ID(b, c) as gid\n        |FROM MyTable\n        |     GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingSetsWithOneGrouping() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno,\n        |    AVG(age) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(deptno) AS gb,\n        |    GROUPING_ID(deptno) AS gib\n        |FROM emps GROUP BY GROUPING SETS (deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBasicGroupingSets() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno))");
    }

    @Test
    public void testGroupingSetsOnExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1, COUNT(*) AS c FROM emps GROUP BY GROUPING SETS ((), (deptno + 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleCube() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testRollupOn1Column() {
        this.util().verifyExecPlan("SELECT deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno)");
    }

    @Test
    public void testRollupOn2Column() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT gender, deptno + 1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupOnColumnWithNulls() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender)");
    }

    @Test
    public void testRollupPlusOrderBy() {
        this.util().verifyExecPlan("SELECT gender, COUNT(*) AS c FROM emp GROUP BY ROLLUP(gender) ORDER BY c DESC");
    }

    @Test
    public void testRollupCartesianProduct() {
        this.util().verifyExecPlan("SELECT deptno, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno), ROLLUP(gender)");
    }

    @Test
    public void testRollupCartesianProductOfWithTupleWithExpression() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno / 2 + 1 AS half1, COUNT(*) AS c FROM emp\n        |GROUP BY ROLLUP(deptno / 2, gender), ROLLUP(substring(ename FROM 1 FOR 1))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testRollupWithHaving() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) HAVING COUNT(*) > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAndDistinct() {
        this.util().verifyExecPlan("SELECT DISTINCT COUNT(*) FROM emp GROUP BY CUBE(deptno, gender)");
    }

    @Test
    public void testCubeAndJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT e.deptno, e.gender,\n        |    MIN(e.ename) AS min_name\n        |FROM emp AS e JOIN dept AS d USING (deptno)\n        |    GROUP BY CUBE(e.deptno, d.deptno, e.gender)\n        |    HAVING COUNT(*) > 2 OR gender = 'M' AND e.deptno = 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfGroupByQuery() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c, GROUPING(deptno) AS g FROM emp GROUP BY deptno");
    }

    @Test
    public void testGroupingInSelectClauseOfCubeQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job,\n        |    COUNT(*) AS c,\n        |    GROUPING(deptno) AS d,\n        |    GROUPING(job) j,\n        |    GROUPING(deptno, job) AS x\n        |FROM scott_emp GROUP BY CUBE(deptno, job)\n        |\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGroup_idGrouping_idInSelectClauseOfGroupByQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) as c,\n        |    GROUPING(deptno) AS g,\n        |    GROUP_ID() AS gid,\n        |    GROUPING_ID(deptno) AS gd,\n        |    GROUPING_ID(gender) AS gg,\n        |    GROUPING_ID(gender, deptno) AS ggd,\n        |    GROUPING_ID(deptno, gender) AS gdg\n        |FROM emp GROUP BY ROLLUP(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingAcceptsMultipleArgumentsGivesSameResultAsGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c,\n        |    GROUPING(deptno) AS gd,\n        |    GROUPING_ID(deptno) AS gid,\n        |    GROUPING(deptno, gender, deptno) AS gdgd,\n        |    GROUPING_ID(deptno, gender, deptno) AS gidgd\n        |FROM emp\n        |    GROUP BY ROLLUP(deptno, gender)\n        |    HAVING GROUPING(deptno) <= GROUPING_ID(deptno, gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInOrderByClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(deptno) ORDER BY GROUPING(deptno), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDuplicateArgumentToGrouping_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING_ID(deptno, gender, deptno),\n        |    COUNT(*) AS c\n        |FROM emp WHERE deptno = 10\n        |    GROUP BY ROLLUP(gender, deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingInSelectClauseOfRollupQuery() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*) AS c, deptno, GROUPING(deptno) AS g FROM emp GROUP BY ROLLUP(deptno)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testGroupingGrouping_idAndGroup_id() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, gender,\n        |    GROUPING(deptno) gd,\n        |    GROUPING(gender) gg,\n        |    GROUPING_ID(deptno, gender) dg,\n        |    GROUPING_ID(gender, deptno) gd,\n        |    GROUP_ID() gid,\n        |    COUNT(*) c\n        |FROM emp\n        |    GROUP BY CUBE(deptno, gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno + 1 AS d1, deptno + 1 - 1 AS d0, COUNT(*) AS c\n        |FROM emp GROUP BY ROLLUP (deptno + 1)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY CUBE(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInRollup2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select MOD(deptno, 20) AS d, COUNT(*) AS c, gender AS g\n        |FROM emp GROUP BY ROLLUP(MOD(deptno, 20), gender)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testAllowExpressionInCube2() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY CUBE(1)");
    }

    @Test
    public void testAllowExpressionInRollup3() {
        this.util().verifyExecPlan("SELECT COUNT(*) AS c FROM emp GROUP BY ROLLUP(1)");
    }

    @Test
    public void testCALCITE1824() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("GROUPING SETS are currently not supported");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, GROUP_ID() AS g, COUNT(*) AS c\n        |FROM scott_emp GROUP BY GROUPING SETS (deptno, (), ())\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testFromBlogspot() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT deptno, job, empno, ename, SUM(sal) sumsal,\n        |    CASE GROUPING_ID(deptno, job, empno)\n        |    WHEN 0 THEN CAST('grouped by deptno,job,empno,ename' as varchar)\n        |    WHEN 1 THEN CAST('grouped by deptno,job' as varchar)\n        |    WHEN 3 THEN CAST('grouped by deptno' as varchar)\n        |    WHEN 7 THEN CAST('grouped by ()' as varchar)\n        |    END gr_text\n        |from scott_emp\n        |    GROUP BY ROLLUP(deptno, job, (empno,ename))\n        |    ORDER BY deptno, job, empno\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCubeAsGroupingSets() {
        String cubeQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY CUBE (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), (c), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(cubeQuery, groupingSetsQuery);
        this.util().verifyExecPlan(cubeQuery);
    }

    @Test
    public void testRollupAsGroupingSets() {
        String rollupQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY ROLLUP (b, c)\n      ")).stripMargin();
        String groupingSetsQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT b, c,\n        |    AVG(a) AS a,\n        |    GROUP_ID() AS g,\n        |    GROUPING(b) AS gb,\n        |    GROUPING(c) AS gc,\n        |    GROUPING_ID(b) AS gib,\n        |    GROUPING_ID(c) as gic,\n        |    GROUPING_ID(b, c) AS gid\n        |FROM MyTable\n        |    GROUP BY GROUPING SETS ((b, c), (b), ())\n      ")).stripMargin();
        this.verifyPlanIdentical(rollupQuery, groupingSetsQuery);
        this.util().verifyExecPlan(rollupQuery);
    }

    public void verifyPlanIdentical(String sql1, String sql2) {
        Table table1 = this.util().tableEnv().sqlQuery(sql1);
        Table table2 = this.util().tableEnv().sqlQuery(sql2);
        RelNode optimized1 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table1));
        RelNode optimized2 = this.util().getPlanner().optimize(TableTestUtil$.MODULE$.toRelNode(table2));
        Assert.assertEquals((Object)FlinkRelOptUtil$.MODULE$.toString(optimized1, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()), (Object)FlinkRelOptUtil$.MODULE$.toString(optimized2, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
    }

    public GroupingSetsTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender"))}), new CaseClassTypeInfo<Tuple3<String, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, String>>(this, fieldSerializers){

                    public Tuple3<String, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("dept", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "dname"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("emps", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "gender")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "city")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empid")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "slacker")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "manager")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "joinedat"))}), new CaseClassTypeInfo<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>> unused = new ScalaCaseClassSerializer<Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date>>(this, fieldSerializers){

                    public Tuple10<Object, String, Object, String, String, Object, Object, Object, Object, Date> createInstance(Object[] fields) {
                        return new Tuple10((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]), (Object)((String)fields[4]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[5])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[6])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[7])), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[8])), (Object)((Date)fields[9]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("scott_emp", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "empno")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ename")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "job")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "mgr")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "hiredate")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "sal")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "comm")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "deptno"))}), new CaseClassTypeInfo<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple8<Object, String, String, Object, Date, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple8<Object, String, String, Object, Date, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple8((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Date)fields[4]), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[6])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[7])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.agg.GroupingSetsTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

