/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.PartitionableSinkTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001'\t)\u0002+\u0019:uSRLwN\\1cY\u0016\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\n%\n1b\u0019:fCR,G+\u00192mKR\u0019!\u0006M\u001f\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\u001d\u0002\rAM\u0001\u0005]\u0006lW\r\u0005\u00024u9\u0011A\u0007\u000f\t\u0003k1j\u0011A\u000e\u0006\u0003oI\ta\u0001\u0010:p_Rt\u0014BA\u001d-\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eb\u0003\"\u0002 (\u0001\u0004y\u0014!C:ik\u001a4G.\u001a\"z!\tY\u0003)\u0003\u0002BY\t9!i\\8mK\u0006t\u0007\"B\"\u0001\t\u0003!\u0015A\u0003;fgR\u001cF/\u0019;jGR\t!\u0006\u000b\u0002C\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0017\"\u0013A\u0001V3ti\")Q\n\u0001C\u0001\t\u0006YA/Z:u\tft\u0017-\\5dQ\tae\tC\u0003Q\u0001\u0011\u0005A)\u0001\u000buKN$H)\u001f8b[&\u001c7\u000b[;gM2,')\u001f\u0015\u0003\u001f\u001aCQa\u0015\u0001\u0005\u0002\u0011\u000b1\u0002^3tiB\u000b'\u000f^5bY\"\u0012!K\u0012\u0005\u0006-\u0002!\t\u0001R\u0001\u0010i\u0016\u001cHo\u0016:p]\u001e\u001cF/\u0019;jG\"\"QK\u0012-Z\u0003!)\u0007\u0010]3di\u0016$7%\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uS\u0011aA1qS&\u0011q\f\u0018\u0002\u0014-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c\u0005\u0006C\u0002!\t\u0001R\u0001\u0010i\u0016\u001cHo\u0016:p]\u001e4\u0015.\u001a7eg\"\"\u0001M\u0012-Z\u0001")
public class PartitionableSinkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    private void createTable(String name, boolean shuffleBy) {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(270).append("\n         |create table ").append(name).append(" (\n         |  a bigint,\n         |  b bigint,\n         |  c bigint\n         |) partitioned by (b, c) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '/non',\n         |  ").append((Object)(shuffleBy ? "'sink.shuffle-by-partition.enable'='true'," : "")).append("\n         |  'format' = 'testcsv'\n         |)\n         |").toString())).stripMargin());
    }

    @Test
    public void testStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1, c=1) SELECT a FROM MyTable");
    }

    @Test
    public void testDynamic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testDynamicShuffleBy() {
        this.createTable("sinkShuffleBy", true);
        this.util().verifyExecPlanInsert("INSERT INTO sinkShuffleBy SELECT a, b, c FROM MyTable");
    }

    @Test
    public void testPartial() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongStatic() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (a=1) SELECT b, c FROM MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testWrongFields() {
        this.util().verifyExecPlanInsert("INSERT INTO sink PARTITION (b=1) SELECT a, b, c FROM MyTable");
    }

    public PartitionableSinkTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.PartitionableSinkTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.createTable("sink", false);
    }
}

