/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class DynamicPartitionPruningRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(TableConfig.getDefault());
    private final TestValuesCatalog catalog = new TestValuesCatalog("testCatalog", "test_database", true);

    @Before
    public void setup() {
        this.catalog.open();
        this.util.tableEnv().registerCatalog("testCatalog", (Catalog)this.catalog);
        this.util.tableEnv().useCatalog("testCatalog");
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_DYNAMIC_FILTERING_ENABLED, (Object)true);
        this.util.tableEnv().executeSql("CREATE TABLE fact_part (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) PARTITIONED BY (fact_date_sk)\nWITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'partition-list' = 'fact_date_sk:1990;fact_date_sk:1991;fact_date_sk:1992',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE dim (\n  id BIGINT,\n  male BOOLEAN,\n  amount BIGINT,\n  price BIGINT,\n  dim_date_sk BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
    }

    @Test
    public void testDimTableFilteringFieldsNotInJoinKey() {
        String query = "Select * from dim, fact_part where fact_part.id = dim.id and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDimTableWithoutFilter() {
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 100";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDimTableWithUnsuitableFilter() {
        String query = "Select * from dim join fact_part on fact_part.fact_date_sk = dim.dim_date_sk where dim.id is not null";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testFactTableIsNotPartitionTable() {
        this.util.tableEnv().executeSql("CREATE TABLE none_part_fact (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) WITH (\n 'connector' = 'values',\n 'runtime-source' = 'NewSource',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        String query = "Select * from dim, none_part_fact where none_part_fact.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testFactTableIsLegacySource() {
        this.util.tableEnv().executeSql("CREATE TABLE legacy_source (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  fact_date_sk BIGINT\n) PARTITIONED BY (fact_date_sk)\nWITH (\n 'connector' = 'values',\n 'runtime-source' = 'SourceFunction',\n 'partition-list' = 'fact_date_sk:1990;fact_date_sk:1991;fact_date_sk:1992',\n 'dynamic-filtering-fields' = 'fact_date_sk;amount',\n 'bounded' = 'true'\n)");
        String query = "Select * from dim, legacy_source where legacy_source.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDimTableWithFilterPushDown() {
        String query = "Select * from fact_part join (Select * from dim) t1 on fact_part.fact_date_sk = dim_date_sk where t1.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testJoinKeyIsDynamicFilterFieldNotPartitionKey() {
        String query = "Select * from dim, fact_part where fact_part.amount = dim.amount and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInRightRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInLeftRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInRightWithExchangeRule() {
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInLeftWithExchangeRule() {
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInRightWithCalcRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInLeftWithCalcRule() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInRightWithExchangeAndCalcRule() {
        String query = "Select * from dim, fact_part where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFactInLeftWithExchangeAndCalcRule() {
        String query = "Select * from fact_part, dim where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testComplexCalcInFactSide() {
        String query = "Select * from dim join (select fact_date_sk as fact_date_sk1, price + 1 as price1 from fact_part) t1 on t1.fact_date_sk1 = dim_date_sk and t1.price1 > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testPartitionKeysIsComputeColumnsInFactSide() {
        String query = "Select * from dim join (select fact_date_sk + 1 as fact_date_sk1, price + 1 as price1 from fact_part) t1 on t1.fact_date_sk1 = dim_date_sk and t1.price1 > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testPartitionKeysOrderIsChangedInFactSide() {
        String query = "Select * from dim join (select fact_date_sk, id, name, amount, price from fact_part) t1 on t1.fact_date_sk = dim_date_sk and t1.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testPartitionKeysNameIsChangedInFactSide() {
        String query = "Select * from dim join (select id, name, amount, price, fact_date_sk as fact_date_sk1 from fact_part) t1 on t1.fact_date_sk1 = dim_date_sk and t1.price > 200 and dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDynamicFilteringFieldIsComputeColumnsInFactSide() throws TableNotExistException {
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(1L, 1, 1L, 1L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        String query = "Select * from dim join (select fact_date_sk, amount + 1 as amount from fact_part) t1 on fact_date_sk = dim_date_sk and t1.amount = dim.amount where dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testLeftOuterJoinWithFactInLeft() {
        String query = "Select * from fact_part left outer join dim on fact_part.fact_date_sk = dim.dim_date_sk where dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testLeftOutJoinWithFactInRight() {
        String query = "Select * from dim left outer join fact_part on fact_part.fact_date_sk = dim.dim_date_sk where dim.price < 500";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testSemiJoin() {
        String query = "Select * from fact_part where fact_part.fact_date_sk in (select dim_date_sk from dim where dim.price < 500)";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testFullOuterJoin() {
        String query = "Select * from fact_part full outer join (select *  from dim where dim.price < 500) on fact_date_sk = dim_date_sk";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testAntiJoin() {
        String query = "Select * from fact_part where not exists (select dim_date_sk from dim where dim.price < 500)";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testMultiJoin() {
        this.util.tableEnv().executeSql("CREATE TABLE sales (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        String query = "Select * from fact_part, dim, sales where fact_part.id = sales.id and fact_part.fact_date_sk = dim.dim_date_sk and dim.price < 500 and dim.amount > 100";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testComplexDimSideWithJoinInDimSide() {
        this.util.tableEnv().executeSql("CREATE TABLE sales (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        String query = "Select * from fact_part join (select * from dim, sales, item where dim.id = sales.id and sales.id = item.id and dim.price < 500 and sales.price > 300) dimSide on fact_part.fact_date_sk = dimSide.dim_date_sk";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testComplexDimSideWithAggInDimSide() {
        this.util.tableEnv().executeSql("CREATE TABLE sales (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        String query = "Select * from fact_part join (select dim_date_sk, sum(dim.price) from dim where  dim.price < 500 group by dim_date_sk) dimSide on fact_part.fact_date_sk = dimSide.dim_date_sk";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDPPFactorToReorderTableWithoutStats() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)true);
        String query = "Select * from fact_part, item, dim where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.id = item.id and dim.id = item.id  and dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDPPFactorToReorderTableWithStats() throws TableNotExistException {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)true);
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(10L, 10, 10L, 10L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "dim"), tableStatistics, false);
        this.catalog.alterTableColumnStatistics(new ObjectPath("test_database", "dim"), this.createJoinKeyColumnStats(Arrays.asList("dim_date_sk", "id", "price"), 10L, 1000L, 5L, 10L), false);
        tableStatistics = new CatalogTableStatistics(10L, 10, 10L, 10L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "item"), tableStatistics, false);
        this.catalog.alterTableColumnStatistics(new ObjectPath("test_database", "item"), this.createJoinKeyColumnStats(Collections.singletonList("id"), 10L, 1000L, 5L, 10L), false);
        tableStatistics = new CatalogTableStatistics(10000L, 10000, 10000L, 10000L);
        this.catalog.alterTableStatistics(new ObjectPath("test_database", "fact_part"), tableStatistics, false);
        this.catalog.alterTableColumnStatistics(new ObjectPath("test_database", "fact_part"), this.createJoinKeyColumnStats(Arrays.asList("fact_date_sk", "id"), 100L, 1000000L, 8500L, 9800L), false);
        String query = "Select * from fact_part, item, dim where fact_part.fact_date_sk = dim.dim_date_sk and fact_part.id = item.id and dim.id = item.id  and dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDPPFactorWithFactSideJoinKeyChanged() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)true);
        String query = "Select * from (select fact_date_sk + 1 as fact_date_sk, id from fact_part) fact_part1 join item on fact_part1.id = item.id join dim on fact_part1.fact_date_sk = dim.dim_date_sk where dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDPPFactorWithDimSideJoinKeyChanged() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)true);
        String query = "Select * from fact_part join item on fact_part.id = item.id join (select dim_date_sk + 1 as dim_date_sk, price from dim) dim1 on fact_part.fact_date_sk = dim1.dim_date_sk where dim1.price < 500 and dim1.price > 300";
        this.util.verifyRelPlan(query);
    }

    @Test
    public void testDPPFactorWithJoinKeysNotIncludePartitionKeys() {
        String ddl = "CREATE TABLE test_database.item (\n  id BIGINT,\n  amount BIGINT,\n  price BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)true);
        String query = "Select * from fact_part, item, dim where fact_part.id = dim.id and fact_part.id = item.id and dim.id = item.id  and dim.price < 500 and dim.price > 300";
        this.util.verifyRelPlan(query);
    }

    private CatalogColumnStatistics createJoinKeyColumnStats(List<String> columnNames, Long min, Long max, Long ndv, Long nullCount) {
        CatalogColumnStatisticsDataLong longColStats = new CatalogColumnStatisticsDataLong(min, max, ndv, nullCount);
        HashMap<String, CatalogColumnStatisticsDataLong> colStatsMap = new HashMap<String, CatalogColumnStatisticsDataLong>(1);
        for (String columnName : columnNames) {
            colStatsMap.put(columnName, longColStats);
        }
        return new CatalogColumnStatistics(colStatsMap);
    }
}

