/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoTableSourceScanRule;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoTableSourceScanRuleTestBase;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.junit.Before;
import org.junit.Test;

public class PushFilterIntoTableSourceScanRuleTest
extends PushFilterIntoTableSourceScanRuleTestBase {
    @Before
    public void setup() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        ((BatchTableTestUtil)this.util).buildBatchProgram(FlinkBatchProgram.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util.tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushFilterIntoTableSourceScanRule.INSTANCE, CoreRules.FILTER_PROJECT_TRANSPOSE})).build());
        String ddl1 = "CREATE TABLE MyTable (\n  name STRING,\n  id bigint,\n  amount int,\n  price double\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'amount',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl1);
        String ddl2 = "CREATE TABLE VirtualTable (\n  name STRING,\n  id bigint,\n  amount int,\n  virtualField as amount + 1,\n  price double\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'amount',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl2);
    }

    @Override
    @Test
    public void testLowerUpperPushdown() {
        String ddl = "CREATE TABLE MTable (\n  a STRING,\n  b STRING\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'a;b',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        super.testLowerUpperPushdown();
    }

    @Override
    @Test
    public void testWithInterval() {
        String ddl = "CREATE TABLE MTable (\na TIMESTAMP(3),\nb TIMESTAMP(3)\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true',\n 'filterable-fields' = 'a;b',\n 'disable-lookup' = 'true')";
        this.util.tableEnv().executeSql(ddl);
        super.testWithInterval();
    }
}

