/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.expressions.utils.RichFunc1;
import org.apache.flink.table.planner.plan.rules.logical.DeterministicPythonFunc$;
import org.apache.flink.table.planner.plan.rules.logical.ExpressionReductionRulesTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001'\taR\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]J+H.Z:UKN$(BA\u0002\u0005\u0003\u001dawnZ5dC2T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002\"A\u0003vi&d7/\u0003\u0002\u001a-\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cC\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&\u0001\u0010uKN$X\t\u001f9sKN\u001c\u0018n\u001c8SK\u0012,8\r^5p]^KG\u000f[+E\rR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011T'D\u00014\u0015\t!\u0004#A\u0003kk:LG/\u0003\u00027g\t!A+Z:u\u0011\u0015A\u0004\u0001\"\u0001*\u0003\t\"Xm\u001d;FqB\u0014Xm]:j_:\u0014V\rZ;di&|gnV5uQJK7\r[+E\r\"\u0012q'\r\u0005\u0006w\u0001!\t!K\u00011i\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o%\u0016$Wo\u0019;j_:<\u0016\u000e\u001e5SS\u000eDW\u000b\u0012$B]\u0012LeN^1mS\u0012|\u0005/\u001a8)\u0005i\n\u0004\"\u0002 \u0001\t\u0003I\u0013\u0001\n;fgR,\u0005\u0010\u001d:fgNLwN\u001c*fIV\u001cG/[8o/&$\b\u000eU=uQ>tW\u000b\u0012$)\u0005u\n\u0004\"B!\u0001\t\u0003I\u0013a\b;fgR,\u0005\u0010\u001d:fgNLwN\u001c*fIV\u001cG/[8o/&$\bNU1oI\"\u0012\u0001)\r")
public class ExpressionReductionRulesTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testExpressionReductionWithUDF() {
        this.util().addFunction("MyUdf", Func1$.MODULE$);
        this.util().verifyRelPlan("SELECT MyUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRichUDF() {
        this.util().addFunction("MyUdf", new RichFunc1());
        this.util().getTableEnv().getConfig().addJobParameter("int.value", "10");
        this.util().verifyRelPlan("SELECT myUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRichUDFAndInvalidOpen() {
        this.util().addFunction("MyUdf", new RichFunc1());
        this.util().getTableEnv().getConfig().addJobParameter("fail-for-cached-file", "true");
        this.util().verifyRelPlan("SELECT myUdf(1 + 1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithPythonUDF() {
        this.util().addFunction("PyUdf", DeterministicPythonFunc$.MODULE$);
        this.util().addFunction("MyUdf", Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT PyUdf(), MyUdf(1) FROM MyTable");
    }

    @Test
    public void testExpressionReductionWithRand() {
        this.util().verifyExecPlan("SELECT RAND(), RAND(), RAND(1), RAND(1), RAND_INTEGER(3), RAND_INTEGER(3) FROM MyTable");
    }

    public ExpressionReductionRulesTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.ExpressionReductionRulesTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

