/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.plan.batch.sql.PartitionableSourceTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001M\u0011q\u0003U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\"A1\u0004\u0001BC\u0002\u0013\u0005A$A\u000bt_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:\u0016\u0003u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003Y\u0019x.\u001e:dK\u001a+Go\u00195QCJ$\u0018\u000e^5p]N\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002!U\u001cXmQ1uC2|wMR5mi\u0016\u0014\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002#U\u001cXmQ1uC2|wMR5mi\u0016\u0014\b\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y9z\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000e*\u0001\u0004i\u0002\"\u0002\u0014*\u0001\u0004i\u0002bB\u0019\u0001\u0005\u0004%IAM\u0001\u0005kRLG.F\u00014!\t)B'\u0003\u00026-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u00199\u0004\u0001)A\u0005g\u0005)Q\u000f^5mA!)\u0011\b\u0001C\u0001u\u0005)1/\u001a;vaR\t1\b\u0005\u0002\u001fy%\u0011Qh\b\u0002\u0005+:LG\u000f\u000b\u00029\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\t\u0006\u0013aAQ3g_J,\u0007\"\u0002$\u0001\t\u0003Q\u0014A\t;fgR\u001c\u0016.\u001c9mKB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0017\u0007\u000b\u0002F\u0011B\u0011\u0001)S\u0005\u0003\u0015\u0006\u0013A\u0001V3ti\")A\n\u0001C\u0001u\u0005QC/Z:u!\u0006\u0014H/[1m!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016\u0004Vo\u001d5E_^t\u0007FA&I\u0011\u0015y\u0005\u0001\"\u0001;\u0003m!Xm\u001d;XSRDW\u000b\u001a4B]\u00124\u0016N\u001d;vC2\u001cu\u000e\\;n]\"\u0012a\n\u0013\u0005\u0006%\u0002!\tAO\u0001\u001ai\u0016\u001cH/\u00168d_:4XM\u001d;fI\u0016C\bO]3tg&|g\u000e\u000b\u0002R\u0011\")Q\u000b\u0001C\u0001u\u0005\u0019D/Z:u!V\u001c\b\u000eR8x]B\u000b'\u000f^5uS>t\u0017I\u001c3GS2$XM]:D_:$\u0018-\u001b8QCJ$\u0018\u000e^5p].+\u0017p\u001d\u0015\u0003)\"CQ\u0001\u0017\u0001\u0005\u0002i\nq\t^3tiB+8\u000f\u001b#po:\u0004\u0016M\u001d;ji&|g.\u00118e\r&dG/\u001a:t\u0007>tG/Y5o!\u0006\u0014H/\u001b;j_:\\U-_:XSRD7+\u001b8hY\u0016\u0004&o\u001c6fGRLwN\u001c\u0015\u0003/\"CC\u0001A.bEB\u0011AlX\u0007\u0002;*\u0011a,Q\u0001\u0007eVtg.\u001a:\n\u0005\u0001l&a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002GB\u0011AmZ\u0007\u0002K*\u0011a-Q\u0001\beVtg.\u001a:t\u0013\tAWMA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\u0006U\nA\ta[\u0001\u0018!\u0006\u0014H/\u001b;j_:\f'\r\\3T_V\u00148-\u001a+fgR\u0004\"!\f7\u0007\u000b\u0005\u0011\u0001\u0012A7\u0014\u00051t\u0007C\u0001\u0010p\u0013\t\u0001xD\u0001\u0004B]f\u0014VM\u001a\u0005\u0006U1$\tA\u001d\u000b\u0002W\")A\u000f\u001cC\u0001k\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0003Y\u00042a^>~\u001b\u0005A(BA\u0019z\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001 =\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u001f}\u0006\u0005\u0011BA@ \u0005\u0015\t%O]1z!\rq\u00121A\u0005\u0004\u0003\u000by\"aA!os\":1/!\u0003\u0002\u0018\u0005e\u0001\u0003BA\u0006\u0003#q1\u0001ZA\u0007\u0013\r\ty!Z\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005M\u0011Q\u0003\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(bAA\bK\u0006!a.Y7fC\t\tY\"A\u0018t_V\u00148-\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\:>wBjH\u0006I;tK\u000e\u000bG/\u00197pO\u001aKG\u000e^3s{m\fT\u0010")
public class PartitionableSourceTest
extends TableTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;
    private final BatchTableTestUtil util;

    @Parameterized.Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceTest$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s'\n        |)\n        |")).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE PartitionableAndFilterableTable (\n        |  id int,\n        |  name string,\n        |  part1 string,\n        |  part2 int,\n        |  virtualField as part2 + 1)\n        |  partitioned by (part1, part2)\n        |  with (\n        |    'connector' = 'values',\n        |    'bounded' = 'true',\n        |    'partition-list' = '%s',\n        |    'filterable-fields' = 'id;part1;part2'\n        |)\n        |")).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.util().tableEnv().executeSql(String.format(partitionableTable, partitions));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.util().tableEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.util().tableEnv().useCatalog("test_catalog");
            this.util().tableEnv().executeSql(String.format(partitionableTable, ""));
            this.util().tableEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
            ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
            ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceTest.$anonfun$setup$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSimplePartitionFieldPredicate1() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE part1 = 'A'");
    }

    @Test
    public void testPartialPartitionFieldPredicatePushDown() {
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1");
    }

    @Test
    public void testWithUdfAndVirtualColumn() {
        this.util().addFunction("MyUdf", Func1$.MODULE$);
        this.util().verifyExecPlan("SELECT * FROM PartitionableTable WHERE id > 2 AND MyUdf(part2) < 3");
    }

    @Test
    public void testUnconvertedExpression() {
        this.util().verifyExecPlan("select * from PartitionableTable where trim(part1) = 'A' and part2 > 1");
    }

    @Test
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        this.util().verifyExecPlan("select * from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    @Test
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        this.util().verifyExecPlan("select name from PartitionableAndFilterableTable where part1 = 'A' and part2 > 1 and id > 1");
    }

    public static final /* synthetic */ void $anonfun$setup$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceTest(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

