/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MatchRecognizeTest
extends TableTestBase {
    private BatchTableTestUtil util;

    @Before
    public void before() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.util.getTableEnv().executeSql("CREATE TABLE Ticker (\n  `symbol` VARCHAR,\n  `price` INT,\n  `tax` INT,\n  `ts_ltz` as PROCTIME()\n) with (\n  'connector' = 'values',\n  'bounded' = 'true'\n)");
    }

    @After
    public void after() {
        this.util.getTableEnv().executeSql("DROP TABLE Ticker");
    }

    @Test
    public void testCascadeMatch() {
        String sqlQuery = "SELECT *\nFROM (\n  SELECT\n    symbol,\n    price\n  FROM Ticker\n  MATCH_RECOGNIZE (\n    PARTITION BY symbol\n     ORDER BY ts_ltz    MEASURES\n      A.price as price,\n      A.tax as tax\n    ONE ROW PER MATCH\n    PATTERN (A)\n    DEFINE\n      A AS A.price > 0\n  ) AS T\n  GROUP BY symbol, price\n)\nMATCH_RECOGNIZE (\n  PARTITION BY symbol\n  MEASURES\n    A.price as dPrice\n  PATTERN (A)\n  DEFINE\n    A AS A.symbol = 'a'\n)";
        this.util.verifyExecPlan(sqlQuery);
    }
}

