/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan;

import java.util.Collections;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.plan.FlinkCalciteCatalogReader;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.TestTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class FlinkCalciteCatalogReaderTest {
    private final FlinkTypeFactory typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
    private final String tableMockName = "ts";
    private SchemaPlus rootSchemaPlus;
    private FlinkCalciteCatalogReader catalogReader;

    @Before
    public void init() {
        this.rootSchemaPlus = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        Properties prop = new Properties();
        prop.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), "false");
        CalciteConnectionConfigImpl calciteConnConfig = new CalciteConnectionConfigImpl(prop);
        this.catalogReader = new FlinkCalciteCatalogReader(CalciteSchema.from((SchemaPlus)this.rootSchemaPlus), Collections.emptyList(), (RelDataTypeFactory)this.typeFactory, (CalciteConnectionConfig)calciteConnConfig);
    }

    @Test
    public void testGetFlinkPreparingTableBase() {
        ObjectIdentifier objectIdentifier = ObjectIdentifier.of((String)"a", (String)"b", (String)"c");
        ResolvedSchema schema = new ResolvedSchema(Collections.emptyList(), Collections.emptyList(), null);
        ConnectorCatalogTable catalogTable = ConnectorCatalogTable.source((TableSource)new TestTableSource(true, TableSchema.fromResolvedSchema((ResolvedSchema)schema)), (boolean)true);
        ResolvedCatalogTable resolvedCatalogTable = new ResolvedCatalogTable((CatalogTable)catalogTable, schema);
        CatalogSchemaTable mockTable = new CatalogSchemaTable(ContextResolvedTable.permanent((ObjectIdentifier)objectIdentifier, (Catalog)CatalogManagerMocks.createEmptyCatalog(), (ResolvedCatalogBaseTable)resolvedCatalogTable), FlinkStatistic.UNKNOWN(), true);
        this.rootSchemaPlus.add("ts", (Table)mockTable);
        Prepare.PreparingTable preparingTable = this.catalogReader.getTable(Collections.singletonList("ts"));
        Assertions.assertThat((Object)preparingTable).isInstanceOf(FlinkPreparingTableBase.class);
    }

    @Test
    public void testGetNonFlinkPreparingTableBase() {
        Table nonFlinkTableMock = (Table)Mockito.mock(Table.class);
        PowerMockito.when((Object)nonFlinkTableMock.getRowType((RelDataTypeFactory)this.typeFactory)).thenReturn(Mockito.mock(RelDataType.class));
        this.rootSchemaPlus.add("ts", nonFlinkTableMock);
        Prepare.PreparingTable resultTable = this.catalogReader.getTable(Collections.singletonList("ts"));
        Assertions.assertThat((Object)resultTable).isNotInstanceOf(FlinkPreparingTableBase.class);
    }
}

