/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.alias;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.alias.ClearJoinHintWithInvalidPropagationShuttleTestBase;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.nodes.exec.spec.LookupJoinHintTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Before;
import org.junit.Test;

public class ClearLookupJoinHintWithInvalidPropagationShuttleTest
extends ClearJoinHintWithInvalidPropagationShuttleTestBase {
    @Override
    TableTestUtil getTableTestUtil() {
        return this.streamTestUtil(TableConfig.getDefault());
    }

    @Override
    boolean isBatchMode() {
        return false;
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.util.tableEnv().executeSql("CREATE TABLE src (\n  a BIGINT\n) WITH (\n 'connector' = 'values'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE lookup (\n  a BIGINT\n) WITH (\n 'connector' = 'values'\n)");
    }

    @Test
    public void testNoNeedToClearLookupHint() {
        RelNode root = this.builder.scan(new String[]{"src"}).scan(new String[]{"lookup"}).snapshot(this.builder.getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("lookup", false, true)}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testClearLookupHintWithInvalidPropagationToViewWhileViewHasLookupHints() {
        RelNode root = this.builder.scan(new String[]{"src"}).scan(new String[]{"lookup"}).snapshot(this.builder.getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("lookup", false, true)}).hints(new RelHint[]{RelHint.builder((String)"ALIAS").hintOption("t1").build()}).scan(new String[]{"src"}).snapshot(this.builder.getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("lookup", true, false)}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testClearLookupHintWithInvalidPropagationToSubQuery() {
        RelNode root = this.builder.scan(new String[]{"src"}).scan(new String[]{"lookup"}).snapshot(this.builder.getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{RelHint.builder((String)"ALIAS").hintOption("t1").build()}).scan(new String[]{"src"}).hints(new RelHint[]{RelHint.builder((String)"ALIAS").hintOption("t2").build()}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("lookup", true, true)}).build();
        this.verifyRelPlan(root);
    }
}

