/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExecuteSqlTest$;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u00015\u0011a\"\u0012=fGV$XmU9m)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0005\u00151\u0011!\u0002;bE2,'BA\u0004\t\u0003\u00151G.\u001b8l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0019\tA!\u001e;jY&\u00111\u0003\u0005\u0002\u000b)\u0016\u001cH\u000fT8hO\u0016\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0017%\u001c8\u000b\u001e:fC6Lgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011A\u0001\u0005\u0006+q\u0001\rA\u0006\u0005\bG\u0001\u0011\r\u0011\"\u0003%\u0003-yF/Z7q\r>dG-\u001a:\u0016\u0003\u0015\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000bI,H.Z:\u000b\u0005)R\u0011!\u00026v]&$\u0018B\u0001\u0017(\u0005=!V-\u001c9pe\u0006\u0014\u0018PR8mI\u0016\u0014\bB\u0002\u0018\u0001A\u0003%Q%\u0001\u0007`i\u0016l\u0007OR8mI\u0016\u0014\b\u0005C\u00031\u0001\u0011\u0005A%\u0001\u0006uK6\u0004hi\u001c7eKJD#a\f\u001a\u0011\u0005M\"T\"A\u0015\n\u0005UJ#\u0001\u0002*vY\u0016Dqa\u000e\u0001C\u0002\u0013%\u0001(\u0001\u0005tKR$\u0018N\\4t+\u0005I\u0004C\u0001\u0011;\u0013\tY$AA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000f\u0003\u0004>\u0001\u0001\u0006I!O\u0001\ng\u0016$H/\u001b8hg\u0002Bqa\u0010\u0001A\u0002\u0013\u0005\u0001)\u0001\u0003u\u000b:4X#A!\u0011\u0005\u0001\u0012\u0015BA\"\u0003\u0005A!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG\u000fC\u0004F\u0001\u0001\u0007I\u0011\u0001$\u0002\u0011Q,eN^0%KF$\"a\u0012&\u0011\u0005]A\u0015BA%\u0019\u0005\u0011)f.\u001b;\t\u000f-#\u0015\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\t\r5\u0003\u0001\u0015)\u0003B\u0003\u0015!XI\u001c<!\u0011\u0015y\u0005\u0001\"\u0001Q\u0003=!Xm\u001d;TQ><8i\u001c7v[:\u001cH#A$)\u00059\u0013\u0006CA\u001aT\u0013\t!\u0016F\u0001\u0003UKN$\b\"\u0002,\u0001\t\u0013\u0001\u0016\u0001E5oSR$\u0016M\u00197f\u0003:$g+[3x\u0011\u0015A\u0006\u0001\"\u0003Q\u0003]\u0019\bn\\<BY2\u001cu\u000e\\;n]N4%o\\7UC\ndW\rC\u0003[\u0001\u0011%\u0001+\u0001\u0012tQ><8i\u001c7v[:\u001cx+\u001b;i\u0019&\\Wm\u00117bkN,gI]8n)\u0006\u0014G.\u001a\u0005\u00069\u0002!I\u0001U\u0001&g\"|woQ8mk6t7oV5uQ:{G\u000fT5lK\u000ec\u0017-^:f\rJ|W\u000eV1cY\u0016DQA\u0018\u0001\u0005\nA\u000bac\u001d5po\u0006cGnQ8mk6t7O\u0012:p[ZKWm\u001e\u0005\u0006A\u0002!I\u0001U\u0001\"g\"|woQ8mk6t7oV5uQ2K7.Z\"mCV\u001cXM\u0012:p[ZKWm\u001e\u0005\u0006E\u0002!I\u0001U\u0001%g\"|woQ8mk6t7oV5uQ:{G\u000fT5lK\u000ec\u0017-^:f\rJ|WNV5fo\"\"\u0001\u0001\u001a6l!\t)\u0007.D\u0001g\u0015\t9\u0017&\u0001\u0004sk:tWM]\u0005\u0003S\u001a\u0014qAU;o/&$\b.A\u0003wC2,XmI\u0001m!\ti\u0007/D\u0001o\u0015\ty\u0017&A\u0004sk:tWM]:\n\u0005Et'!\u0004)be\u0006lW\r^3sSj,GmB\u0003t\u0005!\u0005A/\u0001\bFq\u0016\u001cW\u000f^3Tc2$Vm\u001d;\u0011\u0005\u0001*h!B\u0001\u0003\u0011\u000318CA;x!\t9\u00020\u0003\u0002z1\t1\u0011I\\=SK\u001aDQ!H;\u0005\u0002m$\u0012\u0001\u001e\u0005\u0006{V$\tA`\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cH#A@\u0011\r\u0005\u0005\u0011\u0011BA\u0007\u001b\t\t\u0019AC\u0002\u0012\u0003\u000bQ!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\u0019A\u0001\u0006D_2dWm\u0019;j_:\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)!\u0001\u0003mC:<\u0017bA\u000e\u0002\u0012!:A0!\u0007\u0002(\u0005%\u0002\u0003BA\u000e\u0003Cq1!\\A\u000f\u0013\r\tyB\\\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005\r\u0012Q\u0005\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(bAA\u0010]\u0006!a.Y7fC\t\tY#\u0001\u0007jgN#(/Z1n{m\u0004T\u0010")
public class ExecuteSqlTest
extends TestLogger {
    private final boolean isStreaming;
    private final TemporaryFolder _tempFolder;
    private final EnvironmentSettings settings;
    private TableEnvironment tEnv;

    @Parameterized.Parameters(name="isStream={0}")
    public static Collection<Boolean> parameters() {
        return ExecuteSqlTest$.MODULE$.parameters();
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    @Test
    public void testShowColumns() {
        this.initTableAndView();
        this.showAllColumnsFromTable();
        this.showColumnsWithLikeClauseFromTable();
        this.showColumnsWithNotLikeClauseFromTable();
        this.showAllColumnsFromView();
        this.showColumnsWithLikeClauseFromView();
        this.showColumnsWithNotLikeClauseFromView();
    }

    private void initTableAndView() {
        String createClause = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE IF NOT EXISTS orders (\n         | `user` BIGINT NOT NULl,\n         | `product` VARCHAR(32),\n         | `amount` INT,\n         | PRIMARY KEY(`user`) NOT ENFORCED\n         |) ")).stripMargin();
        String createWithClause = new StringOps(Predef$.MODULE$.augmentString("\n         |with (\n         | 'connector' = 'datagen'\n         |)")).stripMargin();
        if (!this.isStreaming) {
            String sinkPath = this._tempFolder().newFolder().toString();
            createWithClause = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n                            |with (\n                            |  'connector' = 'filesystem',\n                            |  'path' = '").append(sinkPath).append("',\n                            |  'format' = 'testcsv'\n                            |)").toString())).stripMargin();
        }
        this.tEnv().executeSql(new StringBuilder(0).append(createClause).append(createWithClause).toString());
        this.tEnv().executeSql("create view orders_view as select * from orders");
    }

    private void showAllColumnsFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), "PRI(user)", null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null}), Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders").collect());
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithLikeClauseFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), "PRI(user)", null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders like '%_r%'").collect());
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithNotLikeClauseFromTable() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders not like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders not like '%_r%'").collect());
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showAllColumnsFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), null, null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null}), Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view").collect());
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithLikeClauseFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"user", "BIGINT", new Boolean(false), null, null, null}), Row.of((Object[])new Object[]{"product", "VARCHAR(32)", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view like '%_r%'").collect());
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    private void showColumnsWithNotLikeClauseFromView() {
        ArrayList expectedResultRows = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{"amount", "INT", new Boolean(true), null, null, null})});
        List resultsWithFrom = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns from orders_view not like '%_r%'").collect());
        List resultsWithIn = CollectionUtil.iteratorToList((Iterator)this.tEnv().executeSql("show columns in orders_view not like '%_r%'").collect());
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithFrom);
        Assert.assertEquals((Object)expectedResultRows, (Object)resultsWithIn);
    }

    public ExecuteSqlTest(boolean isStreaming) {
        this.isStreaming = isStreaming;
        this._tempFolder = new TemporaryFolder();
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
        this.tEnv = TableEnvironment.create((EnvironmentSettings)this.settings());
    }
}

