/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.calls.MethodCallGen;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001#\tqQ\t\u001f;sC\u000e$8)\u00197m\u000f\u0016t'BA\u0002\u0005\u0003\u0015\u0019\u0017\r\u001c7t\u0015\t)a!A\u0004d_\u0012,w-\u001a8\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\tiQ*\u001a;i_\u0012\u001c\u0015\r\u001c7HK:D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0007[\u0016$\bn\u001c3\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012a\u0002:fM2,7\r\u001e\u0006\u0003;y\tA\u0001\\1oO*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001b\u0005\u0019iU\r\u001e5pI\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\"!\n\u0014\u0011\u0005M\u0001\u0001\"B\f#\u0001\u0004A\u0002\"\u0002\u0015\u0001\t\u0003J\u0013\u0001C4f]\u0016\u0014\u0018\r^3\u0015\t)r3g\u0011\t\u0003W1j\u0011\u0001B\u0005\u0003[\u0011\u00111cR3oKJ\fG/\u001a3FqB\u0014Xm]:j_:DQaL\u0014A\u0002A\n1a\u0019;y!\tY\u0013'\u0003\u00023\t\t!2i\u001c3f\u000f\u0016tWM]1u_J\u001cuN\u001c;fqRDQ\u0001N\u0014A\u0002U\n\u0001b\u001c9fe\u0006tGm\u001d\t\u0004m\u0001ScBA\u001c>\u001d\tA4(D\u0001:\u0015\tQ\u0004#\u0001\u0004=e>|GOP\u0005\u0002y\u0005)1oY1mC&\u0011ahP\u0001\ba\u0006\u001c7.Y4f\u0015\u0005a\u0014BA!C\u0005\r\u0019V-\u001d\u0006\u0003}}BQ\u0001R\u0014A\u0002\u0015\u000b!B]3ukJtG+\u001f9f!\t15*D\u0001H\u0015\tA\u0015*A\u0004m_\u001eL7-\u00197\u000b\u0005)C\u0011!\u0002;za\u0016\u001c\u0018B\u0001'H\u0005-aunZ5dC2$\u0016\u0010]3\t\u000b9\u0003A\u0011B(\u0002\u0013\u001d,GOR1di>\u0014HC\u0001)U!\t\t&+D\u0001@\u0013\t\u0019vH\u0001\u0003M_:<\u0007\"B+N\u0001\u00041\u0016\u0001B;oSR\u0004\"a\u00160\u000e\u0003aS!!\u0017.\u0002\tU$\u0018\u000e\u001c\u0006\u00037r\u000bq!\u0019<bi&\u001c\u0017M\u0003\u0002^\u0019\u000591-\u00197dSR,\u0017BA0Y\u0005!!\u0016.\\3V]&$\b")
public class ExtractCallGen
extends MethodCallGen {
    private final Method method;

    @Override
    public GeneratedExpression generate(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType) {
        TimeUnit unit = ((TimeUnitRange)CodeGenUtils$.MODULE$.getEnum((GeneratedExpression)((GeneratedExpression)operands.head()))).startUnit;
        LogicalType tpe = ((GeneratedExpression)operands.apply(1)).resultType();
        TimeUnit timeUnit = unit;
        boolean bl = ((Object)((Object)TimeUnit.YEAR)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.MONTH)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.DAY)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.QUARTER)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.DOY)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.DOW)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.WEEK)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.CENTURY)).equals((Object)timeUnit) ? true : ((Object)((Object)TimeUnit.MILLENNIUM)).equals((Object)timeUnit))))))));
        if (bl) {
            LogicalTypeRoot logicalTypeRoot = tpe.getTypeRoot();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, operands, GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$4(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)terms -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n                   |").append(CodeGenUtils$.MODULE$.qualifyMethod($this.method)).append("(").append(terms.head()).append(",\n                   |    ").append(terms.apply(1)).append(".getMillisecond() / ").append(TimeUnit.DAY.multiplier.intValue()).append(")\n                   |").toString())).stripMargin());
            }
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                return super.generate(ctx, operands, returnType);
            }
            if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                throw new ValidationException(new StringBuilder(41).append("unit ").append((Object)unit).append(" can not be applied to time variable").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, operands, GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$4(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)terms -> {
            String string;
            long factor = this.getFactor(unit);
            LogicalTypeRoot logicalTypeRoot = tpe.getTypeRoot();
            String string2 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? new StringBuilder(17).append(terms.apply(1)).append(".getMillisecond()").toString() : String.valueOf(terms.apply(1));
            String longTerm = string2;
            TimeUnit timeUnit = unit;
            if (((Object)((Object)TimeUnit.QUARTER)).equals((Object)timeUnit)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(52).append("\n               |((").append(longTerm).append(" % ").append(factor).append(") - 1) / ").append(unit$1.multiplier.intValue()).append(" + 1\n               |").toString())).stripMargin();
            } else if (((Object)((Object)TimeUnit.MICROSECOND)).equals((Object)timeUnit)) {
                LogicalTypeRoot logicalTypeRoot2 = tpe.getTypeRoot();
                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot2)) {
                    throw new ValidationException(new StringBuilder(37).append("unit ").append((Object)unit).append(" can not be applied to ").append(tpe.toString()).append(" variable").toString());
                }
                String nanoOfMilliTerm = new StringBuilder(23).append(terms.apply(1)).append(".getNanoOfMillisecond()").toString();
                String string3 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(61).append("\n                   |(").append(longTerm).append(" % ").append(factor).append(") * 1000 + ").append(nanoOfMilliTerm).append(" / 1000\n                 ").toString())).stripMargin();
                string = string3;
            } else if (((Object)((Object)TimeUnit.NANOSECOND)).equals((Object)timeUnit)) {
                LogicalTypeRoot logicalTypeRoot3 = tpe.getTypeRoot();
                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot3)) {
                    throw new ValidationException(new StringBuilder(37).append("unit ").append((Object)unit).append(" can not be applied to ").append(tpe.toString()).append(" variable").toString());
                }
                String nanoOfMilliTerm = new StringBuilder(23).append(terms.apply(1)).append(".getNanoOfMillisecond()").toString();
                String string4 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n                   |(").append(longTerm).append(" % ").append(factor).append(") * 1000000 + ").append(nanoOfMilliTerm).append("\n                 ").toString())).stripMargin();
                string = string4;
            } else {
                string = factor == 1L ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n                 |").append(longTerm).append(" / ").append(unit$1.multiplier.intValue()).append("\n                 |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(46).append("\n                 |(").append(longTerm).append(" % ").append(factor).append(") / ").append(unit$1.multiplier.intValue()).append("\n                 |").toString())).stripMargin();
            }
            return string;
        });
    }

    private long getFactor(TimeUnit unit) {
        long l;
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.DAY)).equals((Object)timeUnit)) {
            l = 1L;
        } else if (((Object)((Object)TimeUnit.HOUR)).equals((Object)timeUnit)) {
            l = TimeUnit.DAY.multiplier.longValue();
        } else if (((Object)((Object)TimeUnit.MINUTE)).equals((Object)timeUnit)) {
            l = TimeUnit.HOUR.multiplier.longValue();
        } else if (((Object)((Object)TimeUnit.SECOND)).equals((Object)timeUnit)) {
            l = TimeUnit.MINUTE.multiplier.longValue();
        } else {
            boolean bl = ((Object)((Object)TimeUnit.MILLISECOND)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.MICROSECOND)).equals((Object)timeUnit) ? true : ((Object)((Object)TimeUnit.NANOSECOND)).equals((Object)timeUnit));
            if (bl) {
                l = TimeUnit.SECOND.multiplier.longValue();
            } else if (((Object)((Object)TimeUnit.MONTH)).equals((Object)timeUnit)) {
                l = TimeUnit.YEAR.multiplier.longValue();
            } else if (((Object)((Object)TimeUnit.QUARTER)).equals((Object)timeUnit)) {
                l = TimeUnit.YEAR.multiplier.longValue();
            } else {
                boolean bl2 = ((Object)((Object)TimeUnit.YEAR)).equals((Object)timeUnit) ? true : (((Object)((Object)TimeUnit.CENTURY)).equals((Object)timeUnit) ? true : ((Object)((Object)TimeUnit.MILLENNIUM)).equals((Object)timeUnit));
                if (bl2) {
                    l = 1L;
                } else {
                    throw new CodeGenException(new StringBuilder(25).append("Unit '").append((Object)unit).append("' is not supported.").toString());
                }
            }
        }
        return l;
    }

    public ExtractCallGen(Method method) {
        this.method = method;
        super(method);
    }
}

