/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.IntegerTypeInfo;
import org.apache.flink.api.common.typeinfo.NumericTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.table.validate.ValidationFailure;
import org.apache.flink.table.validate.ValidationResult;
import org.apache.flink.table.validate.ValidationSuccess$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TypeCheckUtils$ {
    public static TypeCheckUtils$ MODULE$;

    static {
        new TypeCheckUtils$();
    }

    public boolean isAdvanced(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo ? false : (typeInformation instanceof BasicTypeInfo ? false : (typeInformation instanceof SqlTimeTypeInfo ? false : !(typeInformation instanceof TimeIntervalTypeInfo)));
        return bl;
    }

    public boolean isSimple(TypeInformation<?> dataType) {
        return !this.isAdvanced(dataType);
    }

    public boolean isNumeric(TypeInformation<?> dataType) {
        boolean bl;
        TypeInformation<?> typeInformation = dataType;
        if (typeInformation instanceof NumericTypeInfo) {
            bl = true;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            bl = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null);
        }
        return bl;
    }

    public boolean isTemporal(TypeInformation<?> dataType) {
        return this.isTimePoint(dataType) || this.isTimeInterval(dataType);
    }

    public boolean isTimePoint(TypeInformation<?> dataType) {
        return dataType instanceof SqlTimeTypeInfo;
    }

    public boolean isTimeInterval(TypeInformation<?> dataType) {
        return dataType instanceof TimeIntervalTypeInfo;
    }

    public boolean isString(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isBoolean(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isDecimal(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isInteger(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isIntegerFamily(TypeInformation<?> dataType) {
        return dataType instanceof IntegerTypeInfo;
    }

    public boolean isLong(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isIntervalMonths(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        TimeIntervalTypeInfo timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MONTHS;
        return !(typeInformation != null ? !typeInformation.equals((Object)timeIntervalTypeInfo) : timeIntervalTypeInfo != null);
    }

    public boolean isIntervalMillis(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        TimeIntervalTypeInfo timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MILLIS;
        return !(typeInformation != null ? !typeInformation.equals((Object)timeIntervalTypeInfo) : timeIntervalTypeInfo != null);
    }

    public boolean isArray(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        boolean bl = typeInformation instanceof ObjectArrayTypeInfo ? true : (typeInformation instanceof BasicArrayTypeInfo ? true : typeInformation instanceof PrimitiveArrayTypeInfo);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isMap(TypeInformation<?> dataType) {
        return dataType instanceof MapTypeInfo;
    }

    public boolean isComparable(TypeInformation<?> dataType) {
        return Comparable.class.isAssignableFrom(dataType.getTypeClass()) && !this.isArray(dataType);
    }

    public boolean isSimpleStringRepresentation(TypeInformation<?> dataType) {
        return this.isNumeric(dataType) || this.isString(dataType) || this.isTemporal(dataType) || this.isBoolean(dataType);
    }

    public ValidationResult assertNumericExpr(TypeInformation<?> dataType, String caller) {
        ValidationResult validationResult;
        TypeInformation<?> typeInformation = dataType;
        if (typeInformation instanceof NumericTypeInfo) {
            validationResult = ValidationSuccess$.MODULE$;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            validationResult = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringBuilder(34).append(caller).append(" requires numeric types, get ").append(dataType).append(" here").toString());
        }
        return validationResult;
    }

    public ValidationResult assertIntegerFamilyExpr(TypeInformation<?> dataType, String caller) {
        TypeInformation<?> typeInformation = dataType;
        ValidationResult validationResult = typeInformation instanceof IntegerTypeInfo ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringBuilder(35).append(caller).append(" requires integer types but was '").append(dataType).append("'.").toString());
        return validationResult;
    }

    public ValidationResult assertOrderableExpr(TypeInformation<?> dataType, String caller) {
        return dataType.isSortKeyType() ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringBuilder(36).append(caller).append(" requires orderable types, get ").append(dataType).append(" here").toString());
    }

    public void validateEqualsHashCode(String name, TypeInformation<?> t) {
        TypeInformation<?> typeInformation = t;
        if (typeInformation instanceof PojoTypeInfo) {
            PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
            this.validateEqualsHashCode(name, pojoTypeInfo.getClass());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (typeInformation instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)typeInformation;
            this.validateEqualsHashCode(name, t.getTypeClass());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), compositeType.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                TypeInformation subtype = compositeType.getTypeAt(i);
                MODULE$.validateEqualsHashCode(name, subtype);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (typeInformation != null) {
            this.validateEqualsHashCode(name, t.getTypeClass());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(typeInformation);
        }
    }

    public void validateEqualsHashCode(String name, Class<?> c) {
        block4: {
            BoxedUnit boxedUnit;
            while (!c.isPrimitive()) {
                if (c.isArray()) {
                    c = c.getComponentType();
                    continue;
                }
                if (c.getMethod("hashCode", new Class[0]).getDeclaringClass() == Object.class) {
                    throw new ValidationException(new StringBuilder(96).append("Type '").append(c.getCanonicalName()).append("' cannot be used in a ").append(name).append(" operation because it ").append("does not implement a proper hashCode() method.").toString());
                }
                if (c.getMethod("equals", Object.class).getDeclaringClass() == Object.class) {
                    throw new ValidationException(new StringBuilder(94).append("Type '").append(c.getCanonicalName()).append("' cannot be used in a ").append(name).append(" operation because it ").append("does not implement a proper equals() method.").toString());
                }
                boxedUnit = BoxedUnit.UNIT;
                break block4;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPrimitiveWrapper(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<Boolean> clazz3 = Boolean.class;
        if (clazz2 == null) {
            if (clazz3 == null) return true;
        } else if (clazz2.equals(clazz3)) return true;
        Class<?> clazz4 = clazz;
        Class<Byte> clazz5 = Byte.class;
        if (clazz4 == null) {
            if (clazz5 == null) return true;
        } else if (clazz4.equals(clazz5)) return true;
        Class<?> clazz6 = clazz;
        Class<Character> clazz7 = Character.class;
        if (clazz6 == null) {
            if (clazz7 == null) return true;
        } else if (clazz6.equals(clazz7)) return true;
        Class<?> clazz8 = clazz;
        Class<Short> clazz9 = Short.class;
        if (clazz8 == null) {
            if (clazz9 == null) return true;
        } else if (clazz8.equals(clazz9)) return true;
        Class<?> clazz10 = clazz;
        Class<Integer> clazz11 = Integer.class;
        if (clazz10 == null) {
            if (clazz11 == null) return true;
        } else if (clazz10.equals(clazz11)) return true;
        Class<?> clazz12 = clazz;
        Class<Long> clazz13 = Long.class;
        if (clazz12 == null) {
            if (clazz13 == null) return true;
        } else if (clazz12.equals(clazz13)) return true;
        Class<?> clazz14 = clazz;
        Class<Double> clazz15 = Double.class;
        if (clazz14 == null) {
            if (clazz15 == null) return true;
        } else if (clazz14.equals(clazz15)) return true;
        Class<?> clazz16 = clazz;
        Class<Float> clazz17 = Float.class;
        if (clazz16 != null) {
            if (!clazz16.equals(clazz17)) return false;
            return true;
        }
        if (clazz17 == null) return true;
        return false;
    }

    public boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray) {
        if (classArray.length != toClassArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (this.isAssignable(classArray[i], toClassArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    private TypeCheckUtils$() {
        MODULE$ = this;
    }
}

