/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkRelBuilder$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.TemporalTableFunctionImpl;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.plan.logical.rel.LogicalTemporalTableJoin$;
import org.apache.flink.table.plan.rules.logical.GetTemporalTableFunctionCall;
import org.apache.flink.table.plan.rules.logical.LogicalCorrelateToTemporalTableJoinRule$;
import org.apache.flink.table.plan.rules.logical.TemporalTableFunctionCall;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001E\u0011q\u0005T8hS\u000e\fGnQ8se\u0016d\u0017\r^3U_R+W\u000e]8sC2$\u0016M\u00197f\u0015>LgNU;mK*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M9R\"\u0001\u000b\u000b\u0005\u001d)\"B\u0001\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!\u0001\u0007\u000b\u0003\u0015I+Gn\u00149u%VdW\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005!)q\u0004\u0001C\u0005A\u0005aR\r\u001f;sC\u000e$h*Y7f\rJ|W\u000eV5nK\u0006#HO]5ckR,GCA\u0011/!\t\u00113F\u0004\u0002$SA\u0011AeJ\u0007\u0002K)\u0011a\u0005E\u0001\u0007yI|w\u000e\u001e \u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003U\u001dBQa\f\u0010A\u0002A\nQ\u0002^5nK\u0006#HO]5ckR,\u0007CA\u00195\u001b\u0005\u0011$BA\u001a\t\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005U\u0012$AC#yaJ,7o]5p]\")q\u0007\u0001C\u0005q\u0005\u0019\u0012n\u001d)s_\u000e$\u0018.\\3SK\u001a,'/\u001a8dKR\u0011\u0011(\u0010\t\u0003umj\u0011aJ\u0005\u0003y\u001d\u0012qAQ8pY\u0016\fg\u000eC\u0003?m\u0001\u0007q(A\u000buK6\u0004xN]1m)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tC\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\t!\u0015IA\rUK6\u0004xN]1m)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8J[Bd\u0007\"\u0002$\u0001\t\u00139\u0015AI3yiJ\f7\r\u001e(b[\u00164%o\\7Qe&l\u0017M]=LKf\fE\u000f\u001e:jEV$X\r\u0006\u0002\"\u0011\")\u0011*\u0012a\u0001a\u0005QQ\r\u001f9sKN\u001c\u0018n\u001c8\t\u000b-\u0003A\u0011\t'\u0002\u000f=tW*\u0019;dQR\u0011Q\n\u0015\t\u0003u9K!aT\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006#*\u0003\rAU\u0001\u0005G\u0006dG\u000e\u0005\u0002\u0014'&\u0011A\u000b\u0006\u0002\u000f%\u0016dw\n\u001d;Sk2,7)\u00197m\u0011\u00151\u0006\u0001\"\u0003X\u0003U\u0019'/Z1uKJKw\r\u001b;FqB\u0014Xm]:j_:$R\u0001\u00170dW6\u0004\"!\u0017/\u000e\u0003iS!aW\u000b\u0002\u0007I,\u00070\u0003\u0002^5\n9!+\u001a=O_\u0012,\u0007\"B0V\u0001\u0004\u0001\u0017A\u0003:fq\n+\u0018\u000e\u001c3feB\u0011\u0011,Y\u0005\u0003Ej\u0013!BU3y\u0005VLG\u000eZ3s\u0011\u0015!W\u000b1\u0001f\u0003!aWM\u001a;O_\u0012,\u0007C\u00014j\u001b\u00059'B\u00015\u0016\u0003\r\u0011X\r\\\u0005\u0003U\u001e\u0014qAU3m\u001d>$W\rC\u0003m+\u0002\u0007Q-A\u0005sS\u001eDGOT8eK\")a.\u0016a\u0001C\u0005)a-[3mI\")\u0001\u000f\u0001C\u0005c\u0006yq-\u001a;SK2|\u0005\u000f^*dQ\u0016l\u0017\r\u0006\u0002skB\u00111c]\u0005\u0003iR\u0011ABU3m\u001fB$8k\u00195f[\u0006DQA^8A\u0002\u0015\fqA]3m\u001d>$WmB\u0003y\u0005!\u0005\u00110A\u0014M_\u001eL7-\u00197D_J\u0014X\r\\1uKR{G+Z7q_J\fG\u000eV1cY\u0016Tu.\u001b8Sk2,\u0007CA\u000f{\r\u0015\t!\u0001#\u0001|'\tQH\u0010\u0005\u0002;{&\u0011ap\n\u0002\u0007\u0003:L(+\u001a4\t\riQH\u0011AA\u0001)\u0005I\b\"CA\u0003u\n\u0007I\u0011AA\u0004\u0003!Iej\u0015+B\u001d\u000e+U#\u0001\n\t\u000f\u0005-!\u0010)A\u0005%\u0005I\u0011JT*U\u0003:\u001bU\t\t")
public class LogicalCorrelateToTemporalTableJoinRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return LogicalCorrelateToTemporalTableJoinRule$.MODULE$.INSTANCE();
    }

    private String extractNameFromTimeAttribute(Expression timeAttribute) {
        FieldReferenceExpression fieldReferenceExpression;
        Expression expression = timeAttribute;
        if (!(expression instanceof FieldReferenceExpression) || !LogicalTypeChecks.hasRoot((LogicalType)(fieldReferenceExpression = (FieldReferenceExpression)expression).getOutputDataType().getLogicalType(), (LogicalTypeRoot)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            throw new ValidationException(new StringBuilder(49).append("Invalid timeAttribute [").append(timeAttribute).append("] in TemporalTableFunction").toString());
        }
        String string = fieldReferenceExpression.getName();
        return string;
    }

    private boolean isProctimeReference(TemporalTableFunctionImpl temporalTableFunction) {
        FieldReferenceExpression fieldRef = (FieldReferenceExpression)temporalTableFunction.getTimeAttribute();
        return LogicalTypeChecks.isProctimeAttribute((LogicalType)fieldRef.getOutputDataType().getLogicalType());
    }

    private String extractNameFromPrimaryKeyAttribute(Expression expression) {
        Expression expression2 = expression;
        if (!(expression2 instanceof FieldReferenceExpression)) {
            throw new ValidationException(new StringBuilder(101).append("Unsupported expression [").append(expression).append("] as primary key. ").append("Only top-level (not nested) field references are supported.").toString());
        }
        FieldReferenceExpression fieldReferenceExpression = (FieldReferenceExpression)expression2;
        String string = fieldReferenceExpression.getName();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalCorrelate logicalCorrelate = (LogicalCorrelate)call.rel(0);
        Object leftNode = call.rel(1);
        TableFunctionScan rightTableFunctionScan = (TableFunctionScan)call.rel(2);
        RelOptCluster cluster = logicalCorrelate.getCluster();
        Option<TemporalTableFunctionCall> option = new GetTemporalTableFunctionCall(cluster.getRexBuilder(), (RelNode)leftNode).visit(rightTableFunctionScan.getCall());
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            Some some;
            TemporalTableFunctionCall temporalTableFunctionCall;
            if (!(option instanceof Some) || (temporalTableFunctionCall = (TemporalTableFunctionCall)(some = (Some)option).value()) == null) throw new MatchError(option);
            TemporalTableFunction rightTemporalTableFunction = temporalTableFunctionCall.temporalTableFunction();
            RexNode leftTimeAttribute = temporalTableFunctionCall.timeAttribute();
            if (!(rightTemporalTableFunction instanceof TemporalTableFunctionImpl)) throw new MatchError(option);
            TemporalTableFunctionImpl temporalTableFunctionImpl = (TemporalTableFunctionImpl)rightTemporalTableFunction;
            QueryOperation underlyingHistoryTable = temporalTableFunctionImpl.getUnderlyingHistoryTable();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            FlinkRelBuilder relBuilder = FlinkRelBuilder$.MODULE$.of(cluster, this.getRelOptSchema((RelNode)leftNode));
            RelNode rightNode = relBuilder.tableOperation(underlyingHistoryTable).build();
            RexNode rightTimeIndicatorExpression = this.createRightExpression(rexBuilder, (RelNode)leftNode, rightNode, this.extractNameFromTimeAttribute(temporalTableFunctionImpl.getTimeAttribute()));
            RexNode rightPrimaryKeyExpression = this.createRightExpression(rexBuilder, (RelNode)leftNode, rightNode, this.extractNameFromPrimaryKeyAttribute(temporalTableFunctionImpl.getPrimaryKey()));
            relBuilder.push(this.isProctimeReference(temporalTableFunctionImpl) ? LogicalTemporalTableJoin$.MODULE$.createProctime(rexBuilder, cluster, logicalCorrelate.getTraitSet(), (RelNode)leftNode, rightNode, leftTimeAttribute, rightPrimaryKeyExpression) : LogicalTemporalTableJoin$.MODULE$.createRowtime(rexBuilder, cluster, logicalCorrelate.getTraitSet(), (RelNode)leftNode, rightNode, leftTimeAttribute, rightTimeIndicatorExpression, rightPrimaryKeyExpression));
            call.transformTo(relBuilder.build());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RexNode createRightExpression(RexBuilder rexBuilder, RelNode leftNode, RelNode rightNode, String field) {
        int rightReferencesOffset = leftNode.getRowType().getFieldCount();
        RelDataTypeField rightDataTypeField = rightNode.getRowType().getField(field, false, false);
        return rexBuilder.makeInputRef(rightDataTypeField.getType(), rightReferencesOffset + rightDataTypeField.getIndex());
    }

    private RelOptSchema getRelOptSchema(RelNode relNode) {
        while (true) {
            RelNode relNode2;
            if ((relNode2 = relNode) instanceof HepRelVertex) {
                HepRelVertex hepRelVertex = (HepRelVertex)relNode2;
                relNode = hepRelVertex.getCurrentRel();
                continue;
            }
            if (relNode2 instanceof SingleRel) {
                SingleRel singleRel = (SingleRel)relNode2;
                relNode = singleRel.getInput();
                continue;
            }
            if (!(relNode2 instanceof BiRel)) break;
            BiRel biRel = (BiRel)relNode2;
            relNode = biRel.getLeft();
        }
        RelOptSchema relOptSchema = relNode.getTable().getRelOptSchema();
        return relOptSchema;
    }

    public LogicalCorrelateToTemporalTableJoinRule() {
        super(RelOptRule.operand(LogicalCorrelate.class, RelOptRule.some(RelOptRule.operand(RelNode.class, RelOptRule.any()), RelOptRule.operand(TableFunctionScan.class, RelOptRule.none()))), "LogicalCorrelateToTemporalTableJoinRule");
    }
}

