/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.calcite;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.util.SourceStringReader;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.table.api.SqlParserException;

public class CalciteParser {
    private final SqlParser.Config config;

    public CalciteParser(SqlParser.Config config) {
        this.config = config;
    }

    public SqlNode parse(String sql) {
        try {
            SqlParser parser = SqlParser.create(sql, this.config);
            return parser.parseStmt();
        }
        catch (SqlParseException e) {
            throw new SqlParserException("SQL parse failed. " + e.getMessage(), (Throwable)e);
        }
    }

    public SqlIdentifier parseIdentifier(String identifier) {
        try {
            return this.createFlinkParser(identifier).TableApiIdentifier();
        }
        catch (Exception e) {
            throw new SqlParserException(String.format("Invalid SQL identifier %s.", identifier));
        }
    }

    private FlinkSqlParserImpl createFlinkParser(String expr) {
        SourceStringReader reader = new SourceStringReader(expr);
        FlinkSqlParserImpl parser = (FlinkSqlParserImpl)this.config.parserFactory().getParser(reader);
        parser.setTabSize(1);
        parser.setQuotedCasing(this.config.quotedCasing());
        parser.setUnquotedCasing(this.config.unquotedCasing());
        parser.setIdentifierMaxLength(this.config.identifierMaxLength());
        parser.setConformance(this.config.conformance());
        switch (this.config.quoting()) {
            case DOUBLE_QUOTE: {
                parser.switchTo(SqlAbstractParserImpl.LexicalState.DQID);
                break;
            }
            case BACK_TICK: {
                parser.switchTo(SqlAbstractParserImpl.LexicalState.BTID);
                break;
            }
            case BRACKET: {
                parser.switchTo(SqlAbstractParserImpl.LexicalState.DEFAULT);
            }
        }
        return parser;
    }
}

