/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.IntegerTypeInfo;
import org.apache.flink.api.common.typeinfo.NumericTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.table.validate.ValidationFailure;
import org.apache.flink.table.validate.ValidationResult;
import org.apache.flink.table.validate.ValidationSuccess$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class TypeCheckUtils$ {
    public static final TypeCheckUtils$ MODULE$;

    static {
        new TypeCheckUtils$();
    }

    public boolean isAdvanced(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo ? false : (typeInformation instanceof BasicTypeInfo ? false : (typeInformation instanceof SqlTimeTypeInfo ? false : !(typeInformation instanceof TimeIntervalTypeInfo)));
        return bl;
    }

    public boolean isSimple(TypeInformation<?> dataType2) {
        return !this.isAdvanced(dataType2);
    }

    public boolean isNumeric(TypeInformation<?> dataType2) {
        boolean bl;
        TypeInformation<?> typeInformation = dataType2;
        if (typeInformation instanceof NumericTypeInfo) {
            bl = true;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            bl = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null);
        }
        return bl;
    }

    public boolean isTemporal(TypeInformation<?> dataType2) {
        return this.isTimePoint(dataType2) || this.isTimeInterval(dataType2);
    }

    public boolean isTimePoint(TypeInformation<?> dataType2) {
        return dataType2 instanceof SqlTimeTypeInfo;
    }

    public boolean isTimeInterval(TypeInformation<?> dataType2) {
        return dataType2 instanceof TimeIntervalTypeInfo;
    }

    public boolean isString(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isBoolean(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isDecimal(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isInteger(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isIntegerFamily(TypeInformation<?> dataType2) {
        return dataType2 instanceof IntegerTypeInfo;
    }

    public boolean isLong(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isIntervalMonths(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        TimeIntervalTypeInfo timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MONTHS;
        return !(typeInformation != null ? !typeInformation.equals((Object)timeIntervalTypeInfo) : timeIntervalTypeInfo != null);
    }

    public boolean isIntervalMillis(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        TimeIntervalTypeInfo timeIntervalTypeInfo = TimeIntervalTypeInfo.INTERVAL_MILLIS;
        return !(typeInformation != null ? !typeInformation.equals((Object)timeIntervalTypeInfo) : timeIntervalTypeInfo != null);
    }

    public boolean isArray(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        boolean bl = typeInformation instanceof ObjectArrayTypeInfo ? true : (typeInformation instanceof BasicArrayTypeInfo ? true : typeInformation instanceof PrimitiveArrayTypeInfo);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isMap(TypeInformation<?> dataType2) {
        return dataType2 instanceof MapTypeInfo;
    }

    public boolean isComparable(TypeInformation<?> dataType2) {
        return Comparable.class.isAssignableFrom(dataType2.getTypeClass()) && !this.isArray(dataType2);
    }

    public boolean isSimpleStringRepresentation(TypeInformation<?> dataType2) {
        return this.isNumeric(dataType2) || this.isString(dataType2) || this.isTemporal(dataType2) || this.isBoolean(dataType2);
    }

    public ValidationResult assertNumericExpr(TypeInformation<?> dataType2, String caller) {
        ValidationResult validationResult;
        TypeInformation<?> typeInformation = dataType2;
        if (typeInformation instanceof NumericTypeInfo) {
            validationResult = ValidationSuccess$.MODULE$;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            validationResult = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires numeric types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
        }
        return validationResult;
    }

    public ValidationResult assertIntegerFamilyExpr(TypeInformation<?> dataType2, String caller) {
        TypeInformation<?> typeInformation = dataType2;
        ValidationResult validationResult = typeInformation instanceof IntegerTypeInfo ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires integer types but was '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
        return validationResult;
    }

    public ValidationResult assertOrderableExpr(TypeInformation<?> dataType2, String caller) {
        return dataType2.isSortKeyType() ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires orderable types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
    }

    public void validateEqualsHashCode(String name, TypeInformation<?> t) {
        TypeInformation<?> typeInformation;
        block5: {
            block3: {
                block4: {
                    block2: {
                        typeInformation = t;
                        if (!(typeInformation instanceof PojoTypeInfo)) break block2;
                        PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                        this.validateEqualsHashCode(name, pojoTypeInfo.getClass());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(typeInformation instanceof CompositeType)) break block4;
                    CompositeType compositeType = (CompositeType)typeInformation;
                    this.validateEqualsHashCode(name, t.getTypeClass());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), compositeType.getArity()).foreach$mVc$sp((Function1)new Serializable(name, compositeType){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;
                        private final CompositeType x3$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            TypeInformation subtype = this.x3$1.getTypeAt(i);
                            TypeCheckUtils$.MODULE$.validateEqualsHashCode(this.name$1, subtype);
                        }
                        {
                            this.name$1 = name$1;
                            this.x3$1 = x3$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (typeInformation == null) break block5;
                this.validateEqualsHashCode(name, t.getTypeClass());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(typeInformation);
    }

    public void validateEqualsHashCode(String name, Class<?> c) {
        block4: {
            BoxedUnit boxedUnit;
            while (true) {
                if (c.isPrimitive()) {
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!c.isArray()) break;
                c = c.getComponentType();
            }
            if (c.getMethod("hashCode", new Class[0]).getDeclaringClass() == Object.class) {
                throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type '", "' cannot be used in a ", " operation because it "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getCanonicalName(), name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not implement a proper hashCode() method."})).s((Seq)Nil$.MODULE$)).toString());
            }
            if (c.getMethod("equals", Object.class).getDeclaringClass() == Object.class) {
                throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type '", "' cannot be used in a ", " operation because it "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getCanonicalName(), name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not implement a proper equals() method."})).s((Seq)Nil$.MODULE$)).toString());
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPrimitiveWrapper(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        Class<Boolean> clazz3 = Boolean.class;
        if (clazz2 == null) {
            if (clazz3 == null) return true;
        } else if (clazz2.equals(clazz3)) return true;
        Class<?> clazz4 = clazz;
        Class<Byte> clazz5 = Byte.class;
        if (clazz4 == null) {
            if (clazz5 == null) return true;
        } else if (clazz4.equals(clazz5)) return true;
        Class<?> clazz6 = clazz;
        Class<Character> clazz7 = Character.class;
        if (clazz6 == null) {
            if (clazz7 == null) return true;
        } else if (clazz6.equals(clazz7)) return true;
        Class<?> clazz8 = clazz;
        Class<Short> clazz9 = Short.class;
        if (clazz8 == null) {
            if (clazz9 == null) return true;
        } else if (clazz8.equals(clazz9)) return true;
        Class<?> clazz10 = clazz;
        Class<Integer> clazz11 = Integer.class;
        if (clazz10 == null) {
            if (clazz11 == null) return true;
        } else if (clazz10.equals(clazz11)) return true;
        Class<?> clazz12 = clazz;
        Class<Long> clazz13 = Long.class;
        if (clazz12 == null) {
            if (clazz13 == null) return true;
        } else if (clazz12.equals(clazz13)) return true;
        Class<?> clazz14 = clazz;
        Class<Double> clazz15 = Double.class;
        if (clazz14 == null) {
            if (clazz15 == null) return true;
        } else if (clazz14.equals(clazz15)) return true;
        Class<?> clazz16 = clazz;
        Class<Float> clazz17 = Float.class;
        if (clazz16 != null) {
            if (!clazz16.equals(clazz17)) return false;
            return true;
        }
        if (clazz17 == null) return true;
        return false;
    }

    public boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray) {
        if (classArray.length != toClassArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (this.isAssignable(classArray[i], toClassArray[i])) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                if (Integer.TYPE.equals(cls)) {
                    return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Long.TYPE.equals(cls)) {
                    return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Boolean.TYPE.equals(cls)) {
                    return false;
                }
                if (Double.TYPE.equals(cls)) {
                    return false;
                }
                if (Float.TYPE.equals(cls)) {
                    return Double.TYPE.equals(toClass);
                }
                if (Character.TYPE.equals(cls)) {
                    return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Short.TYPE.equals(cls)) {
                    return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                if (Byte.TYPE.equals(cls)) {
                    return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
                }
                return false;
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    private TypeCheckUtils$() {
        MODULE$ = this;
    }
}

