/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001=\u0011!DU8x)&lWmU8siB\u0013xnY3tg\u001a+hn\u0019;j_:T!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u0011;M\u0011\u0001!\u0005\t\u0006%eY\u0012&K\u0007\u0002')\u0011A#F\u0001\nMVt7\r^5p]NT!AF\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0019\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u00035M\u0011AcS3zK\u0012\u0004&o\\2fgN4UO\\2uS>t\u0007C\u0001\u000f\u001e\u0019\u0001!QA\b\u0001C\u0002}\u0011\u0011aS\t\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012qAT8uQ&tw\r\u0005\u0002\"O%\u0011\u0001F\t\u0002\u0004\u0003:L\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tq3F\u0001\u0003D%><\b\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011B\u0019\u0002\u0019%t\u0007/\u001e;S_^$\u0016\u0010]3\u0016\u0003I\u0002\"AK\u001a\n\u0005QZ#\u0001D\"S_^$\u0016\u0010]3J]\u001a|\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u001b%t\u0007/\u001e;S_^$\u0016\u0010]3!\u0011!A\u0004A!b\u0001\n\u0013I\u0014A\u0003:poRLW.Z%eqV\t!\b\u0005\u0002\"w%\u0011AH\t\u0002\u0004\u0013:$\b\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u0017I|w\u000f^5nK&#\u0007\u0010\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0005\u0003\u0006i!o\\<D_6\u0004\u0018M]1u_J,\u0012A\u0011\t\u0004C\r+\u0015B\u0001##\u0005\u0019y\u0005\u000f^5p]B\u0011aiR\u0007\u0002\u0005%\u0011\u0001J\u0001\u0002\u0018\u0007>dG.Z2uS>t'k\\<D_6\u0004\u0018M]1u_JD\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u000fe><8i\\7qCJ\fGo\u001c:!\u0011\u0015a\u0005\u0001\"\u0001N\u0003\u0019a\u0014N\\5u}Q!aj\u0014)R!\r1\u0005a\u0007\u0005\u0006a-\u0003\rA\r\u0005\u0006q-\u0003\rA\u000f\u0005\u0006\u0001.\u0003\rA\u0011\u0005\n'\u0002\u0001\r\u00111A\u0005\nQ\u000b\u0011\u0002Z1uCN#\u0018\r^3\u0016\u0003U\u0003BA\u0016/_C6\tqK\u0003\u0002Y3\u0006)1\u000f^1uK*\u0011!lW\u0001\u0007G>lWn\u001c8\u000b\u0005YA\u0011BA/X\u0005!i\u0015\r]*uCR,\u0007CA\u0011`\u0013\t\u0001'E\u0001\u0003M_:<\u0007c\u00012hS6\t1M\u0003\u0002eK\u0006!Q\u000f^5m\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[2\u0003\t1K7\u000f\u001e\t\u0003U2l\u0011a\u001b\u0006\u0003Y!I!!\\6\u0003\u0007I{w\u000fC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\u0006iA-\u0019;b'R\fG/Z0%KF$\"!\u001d;\u0011\u0005\u0005\u0012\u0018BA:#\u0005\u0011)f.\u001b;\t\u000fUt\u0017\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\t\r]\u0004\u0001\u0015)\u0003V\u0003)!\u0017\r^1Ti\u0006$X\r\t\u0005\ns\u0002\u0001\r\u00111A\u0005\ni\fQ\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X-F\u0001|!\r1FPX\u0005\u0003{^\u0013!BV1mk\u0016\u001cF/\u0019;f\u0011)y\b\u00011AA\u0002\u0013%\u0011\u0011A\u0001\u001aY\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002r\u0003\u0007Aq!\u001e@\u0002\u0002\u0003\u00071\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0015B>\u0002-1\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK\u0002B1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e\u00059q.\u001e;qkR\u001cU#A\u0015\t\u0017\u0005E\u0001\u00011AA\u0002\u0013%\u00111C\u0001\f_V$\b/\u001e;D?\u0012*\u0017\u000fF\u0002r\u0003+A\u0001\"^A\b\u0003\u0003\u0005\r!\u000b\u0005\b\u00033\u0001\u0001\u0015)\u0003*\u0003!yW\u000f\u001e9vi\u000e\u0003\u0003bBA\u000f\u0001\u0011\u0005\u0013qD\u0001\u0005_B,g\u000eF\u0002r\u0003CA\u0001\"a\t\u0002\u001c\u0001\u0007\u0011QE\u0001\u0007G>tg-[4\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011qFA\u0015\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u00111\u0007\u0001\u0005B\u0005U\u0012A\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u000b\bc\u0006]\u00121HA#\u0011\u001d\tI$!\rA\u0002%\na!\u001b8qkR\u001c\u0005\u0002CA\u001f\u0003c\u0001\r!a\u0010\u0002\u0007\r$\b\u0010E\u0002\u0012\u0003\u0003J1!a\u0011\u001a\u0005\u001d\u0019uN\u001c;fqRD\u0001\"a\u0012\u00022\u0001\u0007\u0011\u0011J\u0001\u0004_V$\b#BA&\u0003\u001fJSBAA'\u0015\t!\u0007\"\u0003\u0003\u0002R\u00055#!C\"pY2,7\r^8s\u0011\u001d\t)\u0006\u0001C!\u0003/\nqa\u001c8US6,'\u000fF\u0004r\u00033\ni&!\u001a\t\u000f\u0005m\u00131\u000ba\u0001=\u0006IA/[7fgR\fW\u000e\u001d\u0005\t\u0003{\t\u0019\u00061\u0001\u0002`A\u0019\u0011#!\u0019\n\u0007\u0005\r\u0014D\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\u0005\u001d\u00131\u000ba\u0001\u0003\u0013\u0002")
public class RowTimeSortProcessFunction<K>
extends KeyedProcessFunction<K, CRow, CRow> {
    private final CRowTypeInfo inputRowType;
    private final int rowtimeIdx;
    private final Option<CollectionRowComparator> rowComparator;
    private MapState<Object, List<Row>> dataState;
    private ValueState<Object> lastTriggeringTsState;
    private CRow outputC;

    private CRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private int rowtimeIdx() {
        return this.rowtimeIdx;
    }

    private Option<CollectionRowComparator> rowComparator() {
        return this.rowComparator;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private CRow outputC() {
        return this.outputC;
    }

    private void outputC_$eq(CRow x$1) {
        this.outputC = x$1;
    }

    public void open(Configuration config) {
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType().rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        this.outputC_$eq(new CRow());
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long lastTriggeringTs;
        Row input = inputC.row();
        long rowtime2 = BoxesRunTime.unboxToLong((Object)input.getField(this.rowtimeIdx()));
        if (rowtime2 > (lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value()))) {
            List rows = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)rowtime2));
            if (rows == null) {
                ArrayList<Row> rows2 = new ArrayList<Row>();
                rows2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime2), rows2);
                ctx.timerService().registerEventTimeTimer(rowtime2);
            } else {
                rows.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime2), (Object)rows);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            if (this.rowComparator().isDefined()) {
                Collections.sort(inputs, (Comparator)this.rowComparator().get());
            }
            for (int i = 0; i < inputs.size(); ++i) {
                this.outputC().row_$eq((Row)inputs.get(i));
                out.collect((Object)this.outputC());
            }
            this.dataState().remove((Object)BoxesRunTime.boxToLong((long)timestamp));
            this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        }
    }

    public RowTimeSortProcessFunction(CRowTypeInfo inputRowType, int rowtimeIdx, Option<CollectionRowComparator> rowComparator) {
        this.inputRowType = inputRowType;
        this.rowtimeIdx = rowtimeIdx;
        this.rowComparator = rowComparator;
        Preconditions.checkNotNull(rowComparator);
    }
}

