/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002)\u0005<wM]3hCRLwN\\*uCR,G+\u001f9f!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0005usB,W\u000f^5mg*\u0011A)R\u0001\u0005U\u00064\u0018M\u0003\u0002G\u0011\u0005\u0019\u0011\r]5\n\u0005!\u000b%a\u0003*poRK\b/Z%oM>D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\rS:\u0004X\u000f\u001e*poRK\b/\u001a\t\u0003I1K!!T\u0013\u0003\u0019\r\u0013vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000bq\u0002\u001d:fG\u0016$\u0017N\\4PM\u001a\u001cX\r\u001e\t\u00037EK!A\u0015\u000f\u0003\t1{gn\u001a\u0005\t)\u0002\u0011\t\u0011)A\u0005+\u0006Q!o\\<US6,\u0017\n\u001a=\u0011\u0005m1\u0016BA,\u001d\u0005\rIe\u000e\u001e\u0005\t3\u0002\u0011\t\u0011)A\u00055\u0006Y\u0011/^3ss\u000e{gNZ5h!\tYV,D\u0001]\u0015\t1e!\u0003\u0002_9\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000b\u0001\u0004A\u0011A1\u0002\rqJg.\u001b;?)\u001d\u00117\rZ3gO\"\u00042A\u0005\u0001\u0016\u0011\u0015It\f1\u0001;\u0011\u0015qt\f1\u0001@\u0011\u0015Qu\f1\u0001L\u0011\u0015yu\f1\u0001Q\u0011\u0015!v\f1\u0001V\u0011\u0015Iv\f1\u0001[\u0011%Q\u0007\u00011AA\u0002\u0013%1.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!IQ\u000e\u0001a\u0001\u0002\u0004%IA\\\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA8s!\tY\u0002/\u0003\u0002r9\t!QK\\5u\u0011\u001d\u0019H.!AA\u0002\r\n1\u0001\u001f\u00132\u0011\u0019)\b\u0001)Q\u0005G\u00059q.\u001e;qkR\u0004\u0003\"C<\u0001\u0001\u0004\u0005\r\u0011\"\u0003y\u0003Ua\u0017m\u001d;Ue&<w-\u001a:j]\u001e$6o\u0015;bi\u0016,\u0012!\u001f\t\u0004u~\u0004V\"A>\u000b\u0005ql\u0018!B:uCR,'B\u0001@F\u0003\u0019\u0019w.\\7p]&\u0019\u0011\u0011A>\u0003\u0015Y\u000bG.^3Ti\u0006$X\rC\u0006\u0002\u0006\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0011!\u00077bgR$&/[4hKJLgn\u001a+t'R\fG/Z0%KF$2a\\A\u0005\u0011!\u0019\u00181AA\u0001\u0002\u0004I\bbBA\u0007\u0001\u0001\u0006K!_\u0001\u0017Y\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;fA!Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011BA\n\u0003A\t7mY;nk2\fGo\u001c:Ti\u0006$X-\u0006\u0002\u0002\u0016A!!p`A\f!\u0011\tI\"!\b\u000e\u0005\u0005m!B\u0001\u0014\t\u0013\u0011\ty\"a\u0007\u0003\u0007I{w\u000fC\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0012\u0001F1dGVlW\u000f\\1u_J\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002p\u0003OA\u0011b]A\u0011\u0003\u0003\u0005\r!!\u0006\t\u0011\u0005-\u0002\u0001)Q\u0005\u0003+\t\u0011#Y2dk6,H.\u0019;peN#\u0018\r^3!\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%I!!\r\u0002\u0013\u0011\fG/Y*uCR,WCAA\u001a!\u0019Q\u0018Q\u0007)\u0002:%\u0019\u0011qG>\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004b!a\u000f\u0002B\u0005]QBAA\u001f\u0015\r)\u0014q\b\u0006\u0002\t&!\u00111IA\u001f\u0005\u0011a\u0015n\u001d;\t\u0017\u0005\u001d\u0003\u00011AA\u0002\u0013%\u0011\u0011J\u0001\u000eI\u0006$\u0018m\u0015;bi\u0016|F%Z9\u0015\u0007=\fY\u0005C\u0005t\u0003\u000b\n\t\u00111\u0001\u00024!A\u0011q\n\u0001!B\u0013\t\u0019$\u0001\u0006eCR\f7\u000b^1uK\u0002B1\"a\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002V\u0005Aa-\u001e8di&|g.F\u00010\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\u0002\u0019\u0019,hn\u0019;j_:|F%Z9\u0015\u0007=\fi\u0006\u0003\u0005t\u0003/\n\t\u00111\u00010\u0011\u001d\t\t\u0007\u0001Q!\n=\n\u0011BZ;oGRLwN\u001c\u0011\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h\u0005!q\u000e]3o)\ry\u0017\u0011\u000e\u0005\t\u0003W\n\u0019\u00071\u0001\u0002n\u000511m\u001c8gS\u001e\u0004B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gB\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002x\u0005E$!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002|\u0001!\t%! \u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiR9q.a \u0002\u0004\u0006}\u0005bBAA\u0003s\u0002\raI\u0001\u0007S:\u0004X\u000f^\"\t\u0011\u0005\u0015\u0015\u0011\u0010a\u0001\u0003\u000f\u000b1a\u0019;y!\u0011\tI)a'\u0011\u000f\u0005-\u0015qS\u000b$G5\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0005gk:\u001cG/[8og*\u0019a)a%\u000b\u0007\u0005U\u0005\"A\u0005tiJ,\u0017-\\5oO&!\u0011\u0011TAG\u0005QYU-_3e!J|7-Z:t\rVt7\r^5p]&!\u0011QTAL\u0005\u001d\u0019uN\u001c;fqRD\u0001\"!)\u0002z\u0001\u0007\u00111U\u0001\u0004_V$\b#BAS\u0003S\u001bSBAAT\u0015\t)\u0004\"\u0003\u0003\u0002,\u0006\u001d&!C\"pY2,7\r^8s\u0011\u001d\ty\u000b\u0001C!\u0003c\u000bqa\u001c8US6,'\u000fF\u0004p\u0003g\u000b9,a0\t\u000f\u0005U\u0016Q\u0016a\u0001!\u0006IA/[7fgR\fW\u000e\u001d\u0005\t\u0003\u000b\u000bi\u000b1\u0001\u0002:B!\u0011\u0011RA^\u0013\u0011\ti,a&\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011\u0011UAW\u0001\u0004\t\u0019\u000bC\u0004\u0002D\u0002!\t%!2\u0002\u000b\rdwn]3\u0015\u0003=\u0004")
public class RowTimeBoundedRangeOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRangeOver rowTimeBoundedRangeOver = this;
        synchronized (rowTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (triggeringTs > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            int dataListIndex = 0;
            boolean aggregatesIndex = false;
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
                aggregatesIndex = false;
            }
            Iterator iter = this.dataState().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                long dataTs = BoxesRunTime.unboxToLong(entry.getKey());
                long offset = timestamp - dataTs;
                if (offset <= this.precedingOffset) continue;
                List retractDataList = (List)entry.getValue();
                for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                    Row retractRow = (Row)retractDataList.get(dataListIndex);
                    this.function().retract(accumulators, retractRow);
                }
                iter.remove();
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                Row curRow = (Row)inputs.get(dataListIndex);
                this.function().accumulate(accumulators, curRow);
            }
            this.function().setAggregationResults(accumulators, this.output().row());
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                aggregatesIndex = false;
                this.function().setForwardedFields((Row)inputs.get(dataListIndex), this.output().row());
                out.collect((Object)this.output());
            }
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

