/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;

public class SqlTableOption
extends SqlCall {
    protected static final SqlOperator OPERATOR = new SqlSpecialOperator("TableOption", SqlKind.OTHER);
    private final SqlNode key;
    private final SqlNode value;

    public SqlTableOption(SqlNode key, SqlNode value, SqlParserPos pos) {
        super(pos);
        this.key = Objects.requireNonNull(key, "Option key is missing");
        this.value = Objects.requireNonNull(value, "Option value is missing");
    }

    public SqlNode getKey() {
        return this.key;
    }

    public SqlNode getValue() {
        return this.value;
    }

    public String getKeyString() {
        return ((NlsString)SqlLiteral.value(this.key)).getValue();
    }

    public String getValueString() {
        return ((NlsString)SqlLiteral.value(this.value)).getValue();
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.key, this.value);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.key.unparse(writer, leftPrec, rightPrec);
        writer.keyword("=");
        this.value.unparse(writer, leftPrec, rightPrec);
    }
}

