/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlJsonDepthFunction;
import org.apache.calcite.sql.fun.SqlJsonKeysFunction;
import org.apache.calcite.sql.fun.SqlJsonLengthFunction;
import org.apache.calcite.sql.fun.SqlJsonPrettyFunction;
import org.apache.calcite.sql.fun.SqlJsonRemoveFunction;
import org.apache.calcite.sql.fun.SqlJsonStorageSizeFunction;
import org.apache.calcite.sql.fun.SqlJsonTypeFunction;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlTranslate3Function;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeTransforms;

public abstract class SqlLibraryOperators {
    private static final SqlReturnTypeInference DECODE_RETURN_TYPE = opBinding -> {
        ArrayList<RelDataType> list = new ArrayList<RelDataType>();
        int n = opBinding.getOperandCount();
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                ++i;
            }
            list.add(opBinding.getOperandType(i));
        }
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.leastRestrictive(list);
        if (opBinding.getOperandCount() % 2 == 1) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction DECODE = new SqlFunction("DECODE", SqlKind.DECODE, DECODE_RETURN_TYPE, null, OperandTypes.VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction NVL = new SqlFunction("NVL", SqlKind.NVL, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE_ALL), null, OperandTypes.SAME_SAME, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction LTRIM = new SqlFunction("LTRIM", SqlKind.LTRIM, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction RTRIM = new SqlFunction("RTRIM", SqlKind.RTRIM, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction SUBSTR = new SqlFunction("SUBSTR", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction GREATEST = new SqlFunction("GREATEST", SqlKind.GREATEST, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction LEAST = new SqlFunction("LEAST", SqlKind.LEAST, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL})
    public static final SqlFunction TRANSLATE3 = new SqlTranslate3Function();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_TYPE = new SqlJsonTypeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_DEPTH = new SqlJsonDepthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_LENGTH = new SqlJsonLengthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_KEYS = new SqlJsonKeysFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_PRETTY = new SqlJsonPrettyFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_REMOVE = new SqlJsonRemoveFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_STORAGE_SIZE = new SqlJsonStorageSizeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction LEFT = new SqlFunction("LEFT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction REPEAT = new SqlFunction("REPEAT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.STRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction RIGHT = new SqlFunction("RIGHT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction SPACE = new SqlFunction("SPACE", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction SOUNDEX = new SqlFunction("SOUNDEX", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_4_NULLABLE, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction DIFFERENCE = new SqlFunction("DIFFERENCE", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction REVERSE = new SqlFunction("REVERSE", SqlKind.REVERSE, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);

    private SqlLibraryOperators() {
    }
}

