/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;

public class SqlPrefixOperator
extends SqlOperator {
    public SqlPrefixOperator(String name, SqlKind kind, int prec, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlPrefixOperator.leftPrec(prec, true), SqlPrefixOperator.rightPrec(prec, true), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.PREFIX;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{0}{1}";
    }

    @Override
    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            RelDataType operandType = validator.getValidatedNodeType((SqlNode)call.operand(0));
            if (null == operandType) {
                throw new AssertionError((Object)"operand's type should have been derived");
            }
            if (SqlTypeUtil.inCharFamily(operandType)) {
                SqlCollation collation = operandType.getCollation();
                assert (null != collation) : "An implicit or explicit collation should have been set";
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, type.getCharset(), collation);
            }
        }
        return type;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        if (this.getName().equals("-")) {
            return call.getOperandMonotonicity(0).reverse();
        }
        return super.getMonotonicity(call);
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count != 1) {
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }
}

