/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.HashSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;

public class TableConfigUtils {
    public static boolean isOperatorDisabled(TableConfig tableConfig, OperatorType operatorType) {
        String value2 = tableConfig.getConfiguration().getString(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS);
        if (value2 == null) {
            return false;
        }
        String[] operators = value2.split(",");
        HashSet<OperatorType> operatorSets = new HashSet<OperatorType>();
        for (String operator : operators) {
            if ((operator = operator.trim()).isEmpty()) continue;
            if (operator.equals("HashJoin")) {
                operatorSets.add(OperatorType.BroadcastHashJoin);
                operatorSets.add(OperatorType.ShuffleHashJoin);
                continue;
            }
            operatorSets.add(OperatorType.valueOf(operator));
        }
        return operatorSets.contains((Object)operatorType);
    }

    public static AggregatePhaseStrategy getAggPhaseStrategy(TableConfig tableConfig) {
        String aggPhaseConf = tableConfig.getConfiguration().getString(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY).trim();
        if (aggPhaseConf.isEmpty()) {
            return AggregatePhaseStrategy.AUTO;
        }
        return AggregatePhaseStrategy.valueOf(aggPhaseConf);
    }

    public static CalciteConfig getCalciteConfig(TableConfig tableConfig) {
        return tableConfig.getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT());
    }

    private TableConfigUtils() {
    }
}

